/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class EventSubscriptionUpdateParameters
implements JsonSerializable<EventSubscriptionUpdateParameters> {
    private EventSubscriptionDestination destination;
    private DeliveryWithResourceIdentity deliveryWithResourceIdentity;
    private EventSubscriptionFilter filter;
    private List<String> labels;
    private OffsetDateTime expirationTimeUtc;
    private EventDeliverySchema eventDeliverySchema;
    private RetryPolicy retryPolicy;
    private DeadLetterDestination deadLetterDestination;
    private DeadLetterWithResourceIdentity deadLetterWithResourceIdentity;

    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    public EventSubscriptionUpdateParameters withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.deliveryWithResourceIdentity;
    }

    public EventSubscriptionUpdateParameters withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        this.deliveryWithResourceIdentity = deliveryWithResourceIdentity;
        return this;
    }

    public EventSubscriptionFilter filter() {
        return this.filter;
    }

    public EventSubscriptionUpdateParameters withFilter(EventSubscriptionFilter filter) {
        this.filter = filter;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public EventSubscriptionUpdateParameters withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    public EventSubscriptionUpdateParameters withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    public EventDeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    public EventSubscriptionUpdateParameters withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public EventSubscriptionUpdateParameters withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    public EventSubscriptionUpdateParameters withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.deadLetterWithResourceIdentity;
    }

    public EventSubscriptionUpdateParameters withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        this.deadLetterWithResourceIdentity = deadLetterWithResourceIdentity;
        return this;
    }

    public void validate() {
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.deliveryWithResourceIdentity() != null) {
            this.deliveryWithResourceIdentity().validate();
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
        if (this.retryPolicy() != null) {
            this.retryPolicy().validate();
        }
        if (this.deadLetterDestination() != null) {
            this.deadLetterDestination().validate();
        }
        if (this.deadLetterWithResourceIdentity() != null) {
            this.deadLetterWithResourceIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        jsonWriter.writeJsonField("deliveryWithResourceIdentity", (JsonSerializable)this.deliveryWithResourceIdentity);
        jsonWriter.writeJsonField("filter", (JsonSerializable)this.filter);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expirationTimeUtc", this.expirationTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        jsonWriter.writeStringField("eventDeliverySchema", this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("retryPolicy", (JsonSerializable)this.retryPolicy);
        jsonWriter.writeJsonField("deadLetterDestination", (JsonSerializable)this.deadLetterDestination);
        jsonWriter.writeJsonField("deadLetterWithResourceIdentity", (JsonSerializable)this.deadLetterWithResourceIdentity);
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionUpdateParameters)jsonReader.readObject(reader -> {
            EventSubscriptionUpdateParameters deserializedEventSubscriptionUpdateParameters = new EventSubscriptionUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("destination".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.destination = EventSubscriptionDestination.fromJson(reader);
                    continue;
                }
                if ("deliveryWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.deliveryWithResourceIdentity = DeliveryWithResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.filter = EventSubscriptionFilter.fromJson(reader);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedEventSubscriptionUpdateParameters.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.expirationTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.eventDeliverySchema = EventDeliverySchema.fromString(reader.getString());
                    continue;
                }
                if ("retryPolicy".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.retryPolicy = RetryPolicy.fromJson(reader);
                    continue;
                }
                if ("deadLetterDestination".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.deadLetterDestination = DeadLetterDestination.fromJson(reader);
                    continue;
                }
                if ("deadLetterWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionUpdateParameters.deadLetterWithResourceIdentity = DeadLetterWithResourceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionUpdateParameters;
        });
    }
}

