/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilter;
import java.io.IOException;
import java.util.List;

public final class EventSubscriptionFilter
implements JsonSerializable<EventSubscriptionFilter> {
    private String subjectBeginsWith;
    private String subjectEndsWith;
    private List<String> includedEventTypes;
    private Boolean isSubjectCaseSensitive;
    private Boolean enableAdvancedFilteringOnArrays;
    private List<AdvancedFilter> advancedFilters;

    public String subjectBeginsWith() {
        return this.subjectBeginsWith;
    }

    public EventSubscriptionFilter withSubjectBeginsWith(String subjectBeginsWith) {
        this.subjectBeginsWith = subjectBeginsWith;
        return this;
    }

    public String subjectEndsWith() {
        return this.subjectEndsWith;
    }

    public EventSubscriptionFilter withSubjectEndsWith(String subjectEndsWith) {
        this.subjectEndsWith = subjectEndsWith;
        return this;
    }

    public List<String> includedEventTypes() {
        return this.includedEventTypes;
    }

    public EventSubscriptionFilter withIncludedEventTypes(List<String> includedEventTypes) {
        this.includedEventTypes = includedEventTypes;
        return this;
    }

    public Boolean isSubjectCaseSensitive() {
        return this.isSubjectCaseSensitive;
    }

    public EventSubscriptionFilter withIsSubjectCaseSensitive(Boolean isSubjectCaseSensitive) {
        this.isSubjectCaseSensitive = isSubjectCaseSensitive;
        return this;
    }

    public Boolean enableAdvancedFilteringOnArrays() {
        return this.enableAdvancedFilteringOnArrays;
    }

    public EventSubscriptionFilter withEnableAdvancedFilteringOnArrays(Boolean enableAdvancedFilteringOnArrays) {
        this.enableAdvancedFilteringOnArrays = enableAdvancedFilteringOnArrays;
        return this;
    }

    public List<AdvancedFilter> advancedFilters() {
        return this.advancedFilters;
    }

    public EventSubscriptionFilter withAdvancedFilters(List<AdvancedFilter> advancedFilters) {
        this.advancedFilters = advancedFilters;
        return this;
    }

    public void validate() {
        if (this.advancedFilters() != null) {
            this.advancedFilters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subjectBeginsWith", this.subjectBeginsWith);
        jsonWriter.writeStringField("subjectEndsWith", this.subjectEndsWith);
        jsonWriter.writeArrayField("includedEventTypes", this.includedEventTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isSubjectCaseSensitive", this.isSubjectCaseSensitive);
        jsonWriter.writeBooleanField("enableAdvancedFilteringOnArrays", this.enableAdvancedFilteringOnArrays);
        jsonWriter.writeArrayField("advancedFilters", this.advancedFilters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionFilter fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionFilter)jsonReader.readObject(reader -> {
            EventSubscriptionFilter deserializedEventSubscriptionFilter = new EventSubscriptionFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subjectBeginsWith".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.subjectBeginsWith = reader.getString();
                    continue;
                }
                if ("subjectEndsWith".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.subjectEndsWith = reader.getString();
                    continue;
                }
                if ("includedEventTypes".equals(fieldName)) {
                    List includedEventTypes;
                    deserializedEventSubscriptionFilter.includedEventTypes = includedEventTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isSubjectCaseSensitive".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.isSubjectCaseSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAdvancedFilteringOnArrays".equals(fieldName)) {
                    deserializedEventSubscriptionFilter.enableAdvancedFilteringOnArrays = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("advancedFilters".equals(fieldName)) {
                    List advancedFilters;
                    deserializedEventSubscriptionFilter.advancedFilters = advancedFilters = reader.readArray(reader1 -> AdvancedFilter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionFilter;
        });
    }
}

