/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMappingType;
import com.azure.resourcemanager.eventgrid.models.DynamicDeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.StaticDeliveryAttributeMapping;
import java.io.IOException;

public class DeliveryAttributeMapping
implements JsonSerializable<DeliveryAttributeMapping> {
    private DeliveryAttributeMappingType type = DeliveryAttributeMappingType.fromString("DeliveryAttributeMapping");
    private String name;

    public DeliveryAttributeMappingType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public DeliveryAttributeMapping withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static DeliveryAttributeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryAttributeMapping)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DeliveryAttributeMapping deliveryAttributeMapping;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Static".equals(discriminatorValue)) {
                    deliveryAttributeMapping = StaticDeliveryAttributeMapping.fromJson(readerToUse.reset());
                    return deliveryAttributeMapping;
                }
                if ("Dynamic".equals(discriminatorValue)) {
                    deliveryAttributeMapping = DynamicDeliveryAttributeMapping.fromJson(readerToUse.reset());
                    return deliveryAttributeMapping;
                }
                deliveryAttributeMapping = DeliveryAttributeMapping.fromJsonKnownDiscriminator(readerToUse.reset());
                return deliveryAttributeMapping;
            }
        });
    }

    static DeliveryAttributeMapping fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DeliveryAttributeMapping)jsonReader.readObject(reader -> {
            DeliveryAttributeMapping deserializedDeliveryAttributeMapping = new DeliveryAttributeMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDeliveryAttributeMapping.type = DeliveryAttributeMappingType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryAttributeMapping.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryAttributeMapping;
        });
    }
}

