/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupInner;
import java.io.IOException;
import java.util.List;

public final class ClientGroupsListResult
implements JsonSerializable<ClientGroupsListResult> {
    private List<ClientGroupInner> value;
    private String nextLink;

    public List<ClientGroupInner> value() {
        return this.value;
    }

    public ClientGroupsListResult withValue(List<ClientGroupInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ClientGroupsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ClientGroupsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ClientGroupsListResult)jsonReader.readObject(reader -> {
            ClientGroupsListResult deserializedClientGroupsListResult = new ClientGroupsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedClientGroupsListResult.value = value = reader.readArray(reader1 -> ClientGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedClientGroupsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientGroupsListResult;
        });
    }
}

