/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AdvancedFilterOperatorType;
import com.azure.resourcemanager.eventgrid.models.BoolEqualsAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.IsNotNullAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.IsNullOrUndefinedAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberGreaterThanAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberGreaterThanOrEqualsAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberInAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberInRangeAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberLessThanAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberLessThanOrEqualsAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberNotInAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.NumberNotInRangeAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringBeginsWithAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringContainsAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringEndsWithAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringInAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotBeginsWithAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotContainsAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotEndsWithAdvancedFilter;
import com.azure.resourcemanager.eventgrid.models.StringNotInAdvancedFilter;
import java.io.IOException;

public class AdvancedFilter
implements JsonSerializable<AdvancedFilter> {
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.fromString("AdvancedFilter");
    private String key;

    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    public String key() {
        return this.key;
    }

    public AdvancedFilter withKey(String key) {
        this.key = key;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    public static AdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return (AdvancedFilter)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AdvancedFilter advancedFilter;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("operatorType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("NumberIn".equals(discriminatorValue)) {
                    advancedFilter = NumberInAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberNotIn".equals(discriminatorValue)) {
                    advancedFilter = NumberNotInAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberLessThan".equals(discriminatorValue)) {
                    advancedFilter = NumberLessThanAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberGreaterThan".equals(discriminatorValue)) {
                    advancedFilter = NumberGreaterThanAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberLessThanOrEquals".equals(discriminatorValue)) {
                    advancedFilter = NumberLessThanOrEqualsAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberGreaterThanOrEquals".equals(discriminatorValue)) {
                    advancedFilter = NumberGreaterThanOrEqualsAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("BoolEquals".equals(discriminatorValue)) {
                    advancedFilter = BoolEqualsAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringIn".equals(discriminatorValue)) {
                    advancedFilter = StringInAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringNotIn".equals(discriminatorValue)) {
                    advancedFilter = StringNotInAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringBeginsWith".equals(discriminatorValue)) {
                    advancedFilter = StringBeginsWithAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringEndsWith".equals(discriminatorValue)) {
                    advancedFilter = StringEndsWithAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringContains".equals(discriminatorValue)) {
                    advancedFilter = StringContainsAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberInRange".equals(discriminatorValue)) {
                    advancedFilter = NumberInRangeAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("NumberNotInRange".equals(discriminatorValue)) {
                    advancedFilter = NumberNotInRangeAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringNotBeginsWith".equals(discriminatorValue)) {
                    advancedFilter = StringNotBeginsWithAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringNotEndsWith".equals(discriminatorValue)) {
                    advancedFilter = StringNotEndsWithAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("StringNotContains".equals(discriminatorValue)) {
                    advancedFilter = StringNotContainsAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("IsNullOrUndefined".equals(discriminatorValue)) {
                    advancedFilter = IsNullOrUndefinedAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                if ("IsNotNull".equals(discriminatorValue)) {
                    advancedFilter = IsNotNullAdvancedFilter.fromJson(readerToUse.reset());
                    return advancedFilter;
                }
                advancedFilter = AdvancedFilter.fromJsonKnownDiscriminator(readerToUse.reset());
                return advancedFilter;
            }
        });
    }

    static AdvancedFilter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AdvancedFilter)jsonReader.readObject(reader -> {
            AdvancedFilter deserializedAdvancedFilter = new AdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operatorType".equals(fieldName)) {
                    deserializedAdvancedFilter.operatorType = AdvancedFilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedAdvancedFilter.key = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdvancedFilter;
        });
    }
}

