/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.VerifiedPartnersClient;
import com.azure.resourcemanager.eventgrid.fluent.models.VerifiedPartnerInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.implementation.VerifiedPartnerImpl;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartner;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartners;

public final class VerifiedPartnersImpl
implements VerifiedPartners {
    private static final ClientLogger LOGGER = new ClientLogger(VerifiedPartnersImpl.class);
    private final VerifiedPartnersClient innerClient;
    private final EventGridManager serviceManager;

    public VerifiedPartnersImpl(VerifiedPartnersClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VerifiedPartner> getWithResponse(String verifiedPartnerName, Context context) {
        Response<VerifiedPartnerInner> inner = this.serviceClient().getWithResponse(verifiedPartnerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VerifiedPartnerImpl((VerifiedPartnerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VerifiedPartner get(String verifiedPartnerName) {
        VerifiedPartnerInner inner = this.serviceClient().get(verifiedPartnerName);
        if (inner != null) {
            return new VerifiedPartnerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<VerifiedPartner> list() {
        PagedIterable<VerifiedPartnerInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VerifiedPartnerImpl((VerifiedPartnerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VerifiedPartner> list(String filter, Integer top, Context context) {
        PagedIterable<VerifiedPartnerInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VerifiedPartnerImpl((VerifiedPartnerInner)((Object)inner1), this.manager()));
    }

    private VerifiedPartnersClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

