/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.TopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.DeliveryAttributeListResultImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionFullUrlImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.EventSubscription;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.TopicEventSubscriptions;

public final class TopicEventSubscriptionsImpl
implements TopicEventSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(TopicEventSubscriptionsImpl.class);
    private final TopicEventSubscriptionsClient innerClient;
    private final EventGridManager serviceManager;

    public TopicEventSubscriptionsImpl(TopicEventSubscriptionsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        Response<DeliveryAttributeListResultInner> inner = this.serviceClient().getDeliveryAttributesWithResponse(resourceGroupName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeliveryAttributeListResultImpl((DeliveryAttributeListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeliveryAttributeListResult getDeliveryAttributes(String resourceGroupName, String topicName, String eventSubscriptionName) {
        DeliveryAttributeListResultInner inner = this.serviceClient().getDeliveryAttributes(resourceGroupName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new DeliveryAttributeListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<EventSubscription> getWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        Response<EventSubscriptionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public EventSubscription get(String resourceGroupName, String topicName, String eventSubscriptionName) {
        EventSubscriptionInner inner = this.serviceClient().get(resourceGroupName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscription createOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        EventSubscriptionInner inner = this.serviceClient().createOrUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscription createOrUpdate(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        EventSubscriptionInner inner = this.serviceClient().createOrUpdate(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionInfo, context);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String topicName, String eventSubscriptionName) {
        this.serviceClient().delete(resourceGroupName, topicName, eventSubscriptionName);
    }

    @Override
    public void delete(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        this.serviceClient().delete(resourceGroupName, topicName, eventSubscriptionName, context);
    }

    @Override
    public EventSubscription update(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        EventSubscriptionInner inner = this.serviceClient().update(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public EventSubscription update(String resourceGroupName, String topicName, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        EventSubscriptionInner inner = this.serviceClient().update(resourceGroupName, topicName, eventSubscriptionName, eventSubscriptionUpdateParameters, context);
        if (inner != null) {
            return new EventSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(String resourceGroupName, String topicName, String eventSubscriptionName, Context context) {
        Response<EventSubscriptionFullUrlInner> inner = this.serviceClient().getFullUrlWithResponse(resourceGroupName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EventSubscriptionFullUrlImpl((EventSubscriptionFullUrlInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public EventSubscriptionFullUrl getFullUrl(String resourceGroupName, String topicName, String eventSubscriptionName) {
        EventSubscriptionFullUrlInner inner = this.serviceClient().getFullUrl(resourceGroupName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new EventSubscriptionFullUrlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<EventSubscription> list(String resourceGroupName, String topicName) {
        PagedIterable<EventSubscriptionInner> inner = this.serviceClient().list(resourceGroupName, topicName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<EventSubscription> list(String resourceGroupName, String topicName, String filter, Integer top, Context context) {
        PagedIterable<EventSubscriptionInner> inner = this.serviceClient().list(resourceGroupName, topicName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EventSubscriptionImpl((EventSubscriptionInner)((Object)inner1), this.manager()));
    }

    private TopicEventSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }
}

