/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.implementation.TopicSharedAccessKeysImpl;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopic;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopics;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicSharedAccessKeys;

public final class NamespaceTopicsImpl
implements NamespaceTopics {
    private static final ClientLogger LOGGER = new ClientLogger(NamespaceTopicsImpl.class);
    private final NamespaceTopicsClient innerClient;
    private final EventGridManager serviceManager;

    public NamespaceTopicsImpl(NamespaceTopicsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NamespaceTopic> getWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        Response<NamespaceTopicInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, topicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NamespaceTopicImpl((NamespaceTopicInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NamespaceTopic get(String resourceGroupName, String namespaceName, String topicName) {
        NamespaceTopicInner inner = this.serviceClient().get(resourceGroupName, namespaceName, topicName);
        if (inner != null) {
            return new NamespaceTopicImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicName, context);
    }

    @Override
    public PagedIterable<NamespaceTopic> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<NamespaceTopicInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamespaceTopicImpl((NamespaceTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NamespaceTopic> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        PagedIterable<NamespaceTopicInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamespaceTopicImpl((NamespaceTopicInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<TopicSharedAccessKeys> listSharedAccessKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        Response<TopicSharedAccessKeysInner> inner = this.serviceClient().listSharedAccessKeysWithResponse(resourceGroupName, namespaceName, topicName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TopicSharedAccessKeysImpl((TopicSharedAccessKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TopicSharedAccessKeys listSharedAccessKeys(String resourceGroupName, String namespaceName, String topicName) {
        TopicSharedAccessKeysInner inner = this.serviceClient().listSharedAccessKeys(resourceGroupName, namespaceName, topicName);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        TopicSharedAccessKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, namespaceName, topicName, regenerateKeyRequest);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public TopicSharedAccessKeys regenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        TopicSharedAccessKeysInner inner = this.serviceClient().regenerateKey(resourceGroupName, namespaceName, topicName, regenerateKeyRequest, context);
        if (inner != null) {
            return new TopicSharedAccessKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public NamespaceTopic getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        return (NamespaceTopic)this.getWithResponse(resourceGroupName, namespaceName, topicName, Context.NONE).getValue();
    }

    @Override
    public Response<NamespaceTopic> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, topicName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicName, context);
    }

    private NamespaceTopicsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public NamespaceTopicImpl define(String name) {
        return new NamespaceTopicImpl(name, this.manager());
    }
}

