/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicInner;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSharedAccessKeysInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicsListResult;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NamespaceTopicsClientImpl
implements NamespaceTopicsClient {
    private final NamespaceTopicsService service;
    private final EventGridManagementClientImpl client;

    NamespaceTopicsClientImpl(EventGridManagementClientImpl client) {
        this.service = (NamespaceTopicsService)RestProxy.create(NamespaceTopicsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NamespaceTopicInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NamespaceTopicInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceTopicInner> getAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NamespaceTopicInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceTopicInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceTopicInner get(String resourceGroupName, String namespaceName, String topicName) {
        return (NamespaceTopicInner)((Object)this.getWithResponse(resourceGroupName, namespaceName, topicName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (namespaceTopicInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceTopicInfo is required and cannot be null."));
        }
        namespaceTopicInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), namespaceTopicInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (namespaceTopicInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceTopicInfo is required and cannot be null."));
        }
        namespaceTopicInfo.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), namespaceTopicInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceTopicInner.class), (Type)((Object)NamespaceTopicInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceTopicInner.class), (Type)((Object)NamespaceTopicInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginCreateOrUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceTopicInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceTopicInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceTopicInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo) {
        return (NamespaceTopicInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceTopicInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicInner namespaceTopicInfo, Context context) {
        return (NamespaceTopicInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicInfo, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName, String topicName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName, String topicName) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName) {
        this.deleteAsync(resourceGroupName, namespaceName, topicName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName, Context context) {
        this.deleteAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (namespaceTopicUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceTopicUpdateParameters is required and cannot be null."));
        }
        namespaceTopicUpdateParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), namespaceTopicUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (namespaceTopicUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceTopicUpdateParameters is required and cannot be null."));
        }
        namespaceTopicUpdateParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), namespaceTopicUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceTopicInner.class), (Type)((Object)NamespaceTopicInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginUpdateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NamespaceTopicInner.class), (Type)((Object)NamespaceTopicInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NamespaceTopicInner>, NamespaceTopicInner> beginUpdate(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceTopicInner> updateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NamespaceTopicInner> updateAsync(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceTopicInner update(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters) {
        return (NamespaceTopicInner)((Object)this.updateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceTopicInner update(String resourceGroupName, String namespaceName, String topicName, NamespaceTopicUpdateParameters namespaceTopicUpdateParameters, Context context) {
        return (NamespaceTopicInner)((Object)this.updateAsync(resourceGroupName, namespaceName, topicName, namespaceTopicUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceTopicInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespaceTopicsListResult)res.getValue()).value(), ((NamespaceTopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceTopicInner>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespaceTopicsListResult)res.getValue()).value(), ((NamespaceTopicsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, filter, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, filter, top), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NamespaceTopicInner> listByNamespaceAsync(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName, filter, top, context), nextLink -> this.listByNamespaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceTopicInner> listByNamespace(String resourceGroupName, String namespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByNamespaceAsync(resourceGroupName, namespaceName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NamespaceTopicInner> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByNamespaceAsync(resourceGroupName, namespaceName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSharedAccessKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeysWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSharedAccessKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> listSharedAccessKeysAsync(String resourceGroupName, String namespaceName, String topicName) {
        return this.listSharedAccessKeysWithResponseAsync(resourceGroupName, namespaceName, topicName).flatMap(res -> Mono.justOrEmpty((Object)((TopicSharedAccessKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicSharedAccessKeysInner> listSharedAccessKeysWithResponse(String resourceGroupName, String namespaceName, String topicName, Context context) {
        return (Response)this.listSharedAccessKeysWithResponseAsync(resourceGroupName, namespaceName, topicName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner listSharedAccessKeys(String resourceGroupName, String namespaceName, String topicName) {
        return (TopicSharedAccessKeysInner)this.listSharedAccessKeysWithResponse(resourceGroupName, namespaceName, topicName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> regenerateKeyWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> regenerateKeyWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (regenerateKeyRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regenerateKeyRequest is required and cannot be null."));
        }
        regenerateKeyRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, this.client.getApiVersion(), regenerateKeyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKeyAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateKeyWithResponseAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicSharedAccessKeysInner.class), (Type)((Object)TopicSharedAccessKeysInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKeyAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateKeyWithResponseAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TopicSharedAccessKeysInner.class), (Type)((Object)TopicSharedAccessKeysInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.beginRegenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TopicSharedAccessKeysInner>, TopicSharedAccessKeysInner> beginRegenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.beginRegenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return this.beginRegenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TopicSharedAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.beginRegenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner regenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest) {
        return (TopicSharedAccessKeysInner)this.regenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicSharedAccessKeysInner regenerateKey(String resourceGroupName, String namespaceName, String topicName, TopicRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return (TopicSharedAccessKeysInner)this.regenerateKeyAsync(resourceGroupName, namespaceName, topicName, regenerateKeyRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceTopicInner>> listByNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespaceTopicsListResult)res.getValue()).value(), ((NamespaceTopicsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NamespaceTopicInner>> listByNamespaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NamespaceTopicsListResult)res.getValue()).value(), ((NamespaceTopicsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementC")
    public static interface NamespaceTopicsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespaceTopicInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") NamespaceTopicInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") NamespaceTopicUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespaceTopicsListResult>> listByNamespace(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/listKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TopicSharedAccessKeysInner>> listSharedAccessKeys(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/regenerateKey")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> regenerateKey(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="namespaceName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") TopicRegenerateKeyRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NamespaceTopicsListResult>> listByNamespaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

