/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.DeliveryAttributeListResultImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.implementation.SubscriptionFullUrlImpl;
import com.azure.resourcemanager.eventgrid.implementation.SubscriptionImpl;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.Subscription;
import com.azure.resourcemanager.eventgrid.models.SubscriptionFullUrl;

public final class NamespaceTopicEventSubscriptionsImpl
implements NamespaceTopicEventSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(NamespaceTopicEventSubscriptionsImpl.class);
    private final NamespaceTopicEventSubscriptionsClient innerClient;
    private final EventGridManager serviceManager;

    public NamespaceTopicEventSubscriptionsImpl(NamespaceTopicEventSubscriptionsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Subscription> getWithResponse(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        Response<SubscriptionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionImpl((SubscriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Subscription get(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        SubscriptionInner inner = this.serviceClient().get(resourceGroupName, namespaceName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new SubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicName, eventSubscriptionName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
    }

    @Override
    public PagedIterable<Subscription> listByNamespaceTopic(String resourceGroupName, String namespaceName, String topicName) {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().listByNamespaceTopic(resourceGroupName, namespaceName, topicName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionImpl((SubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Subscription> listByNamespaceTopic(String resourceGroupName, String namespaceName, String topicName, String filter, Integer top, Context context) {
        PagedIterable<SubscriptionInner> inner = this.serviceClient().listByNamespaceTopic(resourceGroupName, namespaceName, topicName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionImpl((SubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        Response<DeliveryAttributeListResultInner> inner = this.serviceClient().getDeliveryAttributesWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeliveryAttributeListResultImpl((DeliveryAttributeListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeliveryAttributeListResult getDeliveryAttributes(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        DeliveryAttributeListResultInner inner = this.serviceClient().getDeliveryAttributes(resourceGroupName, namespaceName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new DeliveryAttributeListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SubscriptionFullUrl> getFullUrlWithResponse(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        Response<SubscriptionFullUrlInner> inner = this.serviceClient().getFullUrlWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionFullUrlImpl((SubscriptionFullUrlInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionFullUrl getFullUrl(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        SubscriptionFullUrlInner inner = this.serviceClient().getFullUrl(resourceGroupName, namespaceName, topicName, eventSubscriptionName);
        if (inner != null) {
            return new SubscriptionFullUrlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Subscription getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        String eventSubscriptionName = ResourceManagerUtils.getValueFromIdByName(id, "eventSubscriptions");
        if (eventSubscriptionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventSubscriptions'.", id)));
        }
        return (Subscription)this.getWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, Context.NONE).getValue();
    }

    @Override
    public Response<Subscription> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        String eventSubscriptionName = ResourceManagerUtils.getValueFromIdByName(id, "eventSubscriptions");
        if (eventSubscriptionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventSubscriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        String eventSubscriptionName = ResourceManagerUtils.getValueFromIdByName(id, "eventSubscriptions");
        if (eventSubscriptionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventSubscriptions'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicName, eventSubscriptionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicName = ResourceManagerUtils.getValueFromIdByName(id, "topics");
        if (topicName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'topics'.", id)));
        }
        String eventSubscriptionName = ResourceManagerUtils.getValueFromIdByName(id, "eventSubscriptions");
        if (eventSubscriptionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'eventSubscriptions'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
    }

    private NamespaceTopicEventSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public SubscriptionImpl define(String name) {
        return new SubscriptionImpl(name, this.manager());
    }
}

