/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.CustomDomainOwnershipValidationResult;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.Namespace;
import com.azure.resourcemanager.eventgrid.models.NamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.NamespaceRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.NamespaceSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.NamespaceSku;
import com.azure.resourcemanager.eventgrid.models.NamespaceUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesConfiguration;
import com.azure.resourcemanager.eventgrid.models.TopicsConfiguration;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicSpacesConfigurationInfo;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicsConfigurationInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class NamespaceImpl
implements Namespace,
Namespace.Definition,
Namespace.Update {
    private NamespaceInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private NamespaceUpdateParameters updateNamespaceUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public NamespaceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public IdentityInfo identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public NamespaceProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public TopicsConfiguration topicsConfiguration() {
        return this.innerModel().topicsConfiguration();
    }

    @Override
    public TopicSpacesConfiguration topicSpacesConfiguration() {
        return this.innerModel().topicSpacesConfiguration();
    }

    @Override
    public Boolean isZoneRedundant() {
        return this.innerModel().isZoneRedundant();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<InboundIpRule> inboundIpRules() {
        List<InboundIpRule> inner = this.innerModel().inboundIpRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public TlsVersion minimumTlsVersionAllowed() {
        return this.innerModel().minimumTlsVersionAllowed();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NamespaceInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public NamespaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Namespace create() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Namespace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaces().createOrUpdate(this.resourceGroupName, this.namespaceName, this.innerModel(), context);
        return this;
    }

    NamespaceImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new NamespaceInner();
        this.serviceManager = serviceManager;
        this.namespaceName = name;
    }

    @Override
    public NamespaceImpl update() {
        this.updateNamespaceUpdateParameters = new NamespaceUpdateParameters();
        return this;
    }

    @Override
    public Namespace apply() {
        this.innerObject = this.serviceManager.serviceClient().getNamespaces().update(this.resourceGroupName, this.namespaceName, this.updateNamespaceUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Namespace apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNamespaces().update(this.resourceGroupName, this.namespaceName, this.updateNamespaceUpdateParameters, context);
        return this;
    }

    NamespaceImpl(NamespaceInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
    }

    @Override
    public Namespace refresh() {
        this.innerObject = (NamespaceInner)((Object)this.serviceManager.serviceClient().getNamespaces().getByResourceGroupWithResponse(this.resourceGroupName, this.namespaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Namespace refresh(Context context) {
        this.innerObject = (NamespaceInner)((Object)this.serviceManager.serviceClient().getNamespaces().getByResourceGroupWithResponse(this.resourceGroupName, this.namespaceName, context).getValue());
        return this;
    }

    @Override
    public Response<NamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(Context context) {
        return this.serviceManager.namespaces().listSharedAccessKeysWithResponse(this.resourceGroupName, this.namespaceName, context);
    }

    @Override
    public NamespaceSharedAccessKeys listSharedAccessKeys() {
        return this.serviceManager.namespaces().listSharedAccessKeys(this.resourceGroupName, this.namespaceName);
    }

    @Override
    public NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest regenerateKeyRequest) {
        return this.serviceManager.namespaces().regenerateKey(this.resourceGroupName, this.namespaceName, regenerateKeyRequest);
    }

    @Override
    public NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest regenerateKeyRequest, Context context) {
        return this.serviceManager.namespaces().regenerateKey(this.resourceGroupName, this.namespaceName, regenerateKeyRequest, context);
    }

    @Override
    public CustomDomainOwnershipValidationResult validateCustomDomainOwnership() {
        return this.serviceManager.namespaces().validateCustomDomainOwnership(this.resourceGroupName, this.namespaceName);
    }

    @Override
    public CustomDomainOwnershipValidationResult validateCustomDomainOwnership(Context context) {
        return this.serviceManager.namespaces().validateCustomDomainOwnership(this.resourceGroupName, this.namespaceName, context);
    }

    @Override
    public NamespaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public NamespaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public NamespaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateNamespaceUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public NamespaceImpl withSku(NamespaceSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateNamespaceUpdateParameters.withSku(sku);
        return this;
    }

    @Override
    public NamespaceImpl withIdentity(IdentityInfo identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateNamespaceUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public NamespaceImpl withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.innerModel().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    @Override
    public NamespaceImpl withTopicsConfiguration(TopicsConfiguration topicsConfiguration) {
        this.innerModel().withTopicsConfiguration(topicsConfiguration);
        return this;
    }

    @Override
    public NamespaceImpl withTopicSpacesConfiguration(TopicSpacesConfiguration topicSpacesConfiguration) {
        this.innerModel().withTopicSpacesConfiguration(topicSpacesConfiguration);
        return this;
    }

    @Override
    public NamespaceImpl withIsZoneRedundant(Boolean isZoneRedundant) {
        this.innerModel().withIsZoneRedundant(isZoneRedundant);
        return this;
    }

    @Override
    public NamespaceImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateNamespaceUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public NamespaceImpl withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.isInCreateMode()) {
            this.innerModel().withInboundIpRules(inboundIpRules);
            return this;
        }
        this.updateNamespaceUpdateParameters.withInboundIpRules(inboundIpRules);
        return this;
    }

    @Override
    public NamespaceImpl withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.innerModel().withMinimumTlsVersionAllowed(minimumTlsVersionAllowed);
        return this;
    }

    @Override
    public NamespaceImpl withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration) {
        this.updateNamespaceUpdateParameters.withTopicSpacesConfiguration(topicSpacesConfiguration);
        return this;
    }

    @Override
    public NamespaceImpl withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration) {
        this.updateNamespaceUpdateParameters.withTopicsConfiguration(topicsConfiguration);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

