/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.EventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class EventSubscriptionsClientImpl
implements EventSubscriptionsClient {
    private final EventSubscriptionsService service;
    private final EventGridManagementClientImpl client;

    EventSubscriptionsClientImpl(EventGridManagementClientImpl client) {
        this.service = (EventSubscriptionsService)RestProxy.create(EventSubscriptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionInner>> getWithResponseAsync(String scope, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionInner>> getWithResponseAsync(String scope, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> getAsync(String scope, String eventSubscriptionName) {
        return this.getWithResponseAsync(scope, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((EventSubscriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventSubscriptionInner> getWithResponse(String scope, String eventSubscriptionName, Context context) {
        return (Response)this.getWithResponseAsync(scope, eventSubscriptionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner get(String scope, String eventSubscriptionName) {
        return (EventSubscriptionInner)((Object)this.getWithResponse(scope, eventSubscriptionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        }
        eventSubscriptionInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        }
        eventSubscriptionInfo.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(scope, eventSubscriptionName, eventSubscriptionInfo);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(scope, eventSubscriptionName, eventSubscriptionInfo, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdate(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        return this.beginCreateOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginCreateOrUpdate(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        return this.beginCreateOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> createOrUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        return this.beginCreateOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> createOrUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        return this.beginCreateOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner createOrUpdate(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo) {
        return (EventSubscriptionInner)((Object)this.createOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner createOrUpdate(String scope, String eventSubscriptionName, EventSubscriptionInner eventSubscriptionInfo, Context context) {
        return (EventSubscriptionInner)((Object)this.createOrUpdateAsync(scope, eventSubscriptionName, eventSubscriptionInfo, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String scope, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String scope, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String scope, String eventSubscriptionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(scope, eventSubscriptionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String scope, String eventSubscriptionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(scope, eventSubscriptionName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String scope, String eventSubscriptionName) {
        return this.beginDeleteAsync(scope, eventSubscriptionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String scope, String eventSubscriptionName, Context context) {
        return this.beginDeleteAsync(scope, eventSubscriptionName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scope, String eventSubscriptionName) {
        return this.beginDeleteAsync(scope, eventSubscriptionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scope, String eventSubscriptionName, Context context) {
        return this.beginDeleteAsync(scope, eventSubscriptionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scope, String eventSubscriptionName) {
        this.deleteAsync(scope, eventSubscriptionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scope, String eventSubscriptionName, Context context) {
        this.deleteAsync(scope, eventSubscriptionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        }
        eventSubscriptionUpdateParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        }
        eventSubscriptionUpdateParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdateAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)EventSubscriptionInner.class), (Type)((Object)EventSubscriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdate(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return this.beginUpdateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<EventSubscriptionInner>, EventSubscriptionInner> beginUpdate(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return this.beginUpdateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> updateAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return this.beginUpdateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionInner> updateAsync(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return this.beginUpdateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner update(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return (EventSubscriptionInner)((Object)this.updateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionInner update(String scope, String eventSubscriptionName, EventSubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return (EventSubscriptionInner)((Object)this.updateAsync(scope, eventSubscriptionName, eventSubscriptionUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String scope, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFullUrl(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String scope, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFullUrl(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionFullUrlInner> getFullUrlAsync(String scope, String eventSubscriptionName) {
        return this.getFullUrlWithResponseAsync(scope, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((EventSubscriptionFullUrlInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventSubscriptionFullUrlInner> getFullUrlWithResponse(String scope, String eventSubscriptionName, Context context) {
        return (Response)this.getFullUrlWithResponseAsync(scope, eventSubscriptionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionFullUrlInner getFullUrl(String scope, String eventSubscriptionName) {
        return (EventSubscriptionFullUrlInner)this.getFullUrlWithResponse(scope, eventSubscriptionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listGlobalBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listGlobalBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top, context), nextLink -> this.listGlobalBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> list() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> list(String filter, Integer top, Context context) {
        return new PagedIterable(this.listAsync(filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionForTopicTypeSinglePageAsync(String topicTypeName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalBySubscriptionForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), topicTypeName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionForTopicTypeSinglePageAsync(String topicTypeName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalBySubscriptionForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), topicTypeName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalBySubscriptionForTopicTypeAsync(String topicTypeName, String filter, Integer top) {
        return new PagedFlux(() -> this.listGlobalBySubscriptionForTopicTypeSinglePageAsync(topicTypeName, filter, top), nextLink -> this.listGlobalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalBySubscriptionForTopicTypeAsync(String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listGlobalBySubscriptionForTopicTypeSinglePageAsync(topicTypeName, filter, top), nextLink -> this.listGlobalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalBySubscriptionForTopicTypeAsync(String topicTypeName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listGlobalBySubscriptionForTopicTypeSinglePageAsync(topicTypeName, filter, top, context), nextLink -> this.listGlobalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listGlobalBySubscriptionForTopicType(String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listGlobalBySubscriptionForTopicTypeAsync(topicTypeName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listGlobalBySubscriptionForTopicType(String topicTypeName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listGlobalBySubscriptionForTopicTypeAsync(topicTypeName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listGlobalByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top), nextLink -> this.listGlobalByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceGroupAsync(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, context), nextLink -> this.listGlobalByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByResourceGroup(String resourceGroupName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupForTopicTypeSinglePageAsync(String resourceGroupName, String topicTypeName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalByResourceGroupForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupForTopicTypeSinglePageAsync(String resourceGroupName, String topicTypeName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalByResourceGroupForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalByResourceGroupForTopicTypeAsync(String resourceGroupName, String topicTypeName, String filter, Integer top) {
        return new PagedFlux(() -> this.listGlobalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, topicTypeName, filter, top), nextLink -> this.listGlobalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalByResourceGroupForTopicTypeAsync(String resourceGroupName, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listGlobalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, topicTypeName, filter, top), nextLink -> this.listGlobalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listGlobalByResourceGroupForTopicTypeAsync(String resourceGroupName, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listGlobalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, topicTypeName, filter, top, context), nextLink -> this.listGlobalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listGlobalByResourceGroupForTopicType(String resourceGroupName, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listGlobalByResourceGroupForTopicTypeAsync(resourceGroupName, topicTypeName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listGlobalByResourceGroupForTopicType(String resourceGroupName, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listGlobalByResourceGroupForTopicTypeAsync(resourceGroupName, topicTypeName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionSinglePageAsync(String location, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalBySubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionSinglePageAsync(String location, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalBySubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionAsync(String location, String filter, Integer top) {
        return new PagedFlux(() -> this.listRegionalBySubscriptionSinglePageAsync(location, filter, top), nextLink -> this.listRegionalBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionAsync(String location) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listRegionalBySubscriptionSinglePageAsync(location, filter, top), nextLink -> this.listRegionalBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionAsync(String location, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listRegionalBySubscriptionSinglePageAsync(location, filter, top, context), nextLink -> this.listRegionalBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalBySubscription(String location) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listRegionalBySubscriptionAsync(location, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalBySubscription(String location, String filter, Integer top, Context context) {
        return new PagedIterable(this.listRegionalBySubscriptionAsync(location, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupSinglePageAsync(String resourceGroupName, String location, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupSinglePageAsync(String resourceGroupName, String location, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupAsync(String resourceGroupName, String location, String filter, Integer top) {
        return new PagedFlux(() -> this.listRegionalByResourceGroupSinglePageAsync(resourceGroupName, location, filter, top), nextLink -> this.listRegionalByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupAsync(String resourceGroupName, String location) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listRegionalByResourceGroupSinglePageAsync(resourceGroupName, location, filter, top), nextLink -> this.listRegionalByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupAsync(String resourceGroupName, String location, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listRegionalByResourceGroupSinglePageAsync(resourceGroupName, location, filter, top, context), nextLink -> this.listRegionalByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalByResourceGroup(String resourceGroupName, String location) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listRegionalByResourceGroupAsync(resourceGroupName, location, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalByResourceGroup(String resourceGroupName, String location, String filter, Integer top, Context context) {
        return new PagedIterable(this.listRegionalByResourceGroupAsync(resourceGroupName, location, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionForTopicTypeSinglePageAsync(String location, String topicTypeName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalBySubscriptionForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), location, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionForTopicTypeSinglePageAsync(String location, String topicTypeName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalBySubscriptionForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), location, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionForTopicTypeAsync(String location, String topicTypeName, String filter, Integer top) {
        return new PagedFlux(() -> this.listRegionalBySubscriptionForTopicTypeSinglePageAsync(location, topicTypeName, filter, top), nextLink -> this.listRegionalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionForTopicTypeAsync(String location, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listRegionalBySubscriptionForTopicTypeSinglePageAsync(location, topicTypeName, filter, top), nextLink -> this.listRegionalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalBySubscriptionForTopicTypeAsync(String location, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listRegionalBySubscriptionForTopicTypeSinglePageAsync(location, topicTypeName, filter, top, context), nextLink -> this.listRegionalBySubscriptionForTopicTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalBySubscriptionForTopicType(String location, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listRegionalBySubscriptionForTopicTypeAsync(location, topicTypeName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalBySubscriptionForTopicType(String location, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listRegionalBySubscriptionForTopicTypeAsync(location, topicTypeName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupForTopicTypeSinglePageAsync(String resourceGroupName, String location, String topicTypeName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalByResourceGroupForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupForTopicTypeSinglePageAsync(String resourceGroupName, String location, String topicTypeName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (topicTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicTypeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalByResourceGroupForTopicType(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, location, topicTypeName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupForTopicTypeAsync(String resourceGroupName, String location, String topicTypeName, String filter, Integer top) {
        return new PagedFlux(() -> this.listRegionalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, location, topicTypeName, filter, top), nextLink -> this.listRegionalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupForTopicTypeAsync(String resourceGroupName, String location, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listRegionalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, location, topicTypeName, filter, top), nextLink -> this.listRegionalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listRegionalByResourceGroupForTopicTypeAsync(String resourceGroupName, String location, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listRegionalByResourceGroupForTopicTypeSinglePageAsync(resourceGroupName, location, topicTypeName, filter, top, context), nextLink -> this.listRegionalByResourceGroupForTopicTypeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalByResourceGroupForTopicType(String resourceGroupName, String location, String topicTypeName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listRegionalByResourceGroupForTopicTypeAsync(resourceGroupName, location, topicTypeName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listRegionalByResourceGroupForTopicType(String resourceGroupName, String location, String topicTypeName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listRegionalByResourceGroupForTopicTypeAsync(resourceGroupName, location, topicTypeName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceSinglePageAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceTypeName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, providerNamespace, resourceTypeName, resourceName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceSinglePageAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (resourceTypeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceTypeName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, providerNamespace, resourceTypeName, resourceName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByResourceSinglePageAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, filter, top), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceSinglePageAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, filter, top), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByResourceAsync(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceSinglePageAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, filter, top, context), nextLink -> this.listByResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByResource(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByResourceAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByResource(String resourceGroupName, String providerNamespace, String resourceTypeName, String resourceName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByResourceAsync(resourceGroupName, providerNamespace, resourceTypeName, resourceName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByDomainTopicSinglePageAsync(String resourceGroupName, String domainName, String topicName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDomainTopic(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, domainName, topicName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByDomainTopicSinglePageAsync(String resourceGroupName, String domainName, String topicName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDomainTopic(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, domainName, topicName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByDomainTopicAsync(String resourceGroupName, String domainName, String topicName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByDomainTopicSinglePageAsync(resourceGroupName, domainName, topicName, filter, top), nextLink -> this.listByDomainTopicNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByDomainTopicAsync(String resourceGroupName, String domainName, String topicName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByDomainTopicSinglePageAsync(resourceGroupName, domainName, topicName, filter, top), nextLink -> this.listByDomainTopicNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventSubscriptionInner> listByDomainTopicAsync(String resourceGroupName, String domainName, String topicName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByDomainTopicSinglePageAsync(resourceGroupName, domainName, topicName, filter, top, context), nextLink -> this.listByDomainTopicNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByDomainTopic(String resourceGroupName, String domainName, String topicName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByDomainTopicAsync(resourceGroupName, domainName, topicName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventSubscriptionInner> listByDomainTopic(String resourceGroupName, String domainName, String topicName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByDomainTopicAsync(resourceGroupName, domainName, topicName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributesWithResponseAsync(String scope, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeliveryAttributes(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributesWithResponseAsync(String scope, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDeliveryAttributes(this.client.getEndpoint(), scope, eventSubscriptionName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeliveryAttributeListResultInner> getDeliveryAttributesAsync(String scope, String eventSubscriptionName) {
        return this.getDeliveryAttributesWithResponseAsync(scope, eventSubscriptionName).flatMap(res -> Mono.justOrEmpty((Object)((DeliveryAttributeListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeliveryAttributeListResultInner> getDeliveryAttributesWithResponse(String scope, String eventSubscriptionName, Context context) {
        return (Response)this.getDeliveryAttributesWithResponseAsync(scope, eventSubscriptionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeliveryAttributeListResultInner getDeliveryAttributes(String scope, String eventSubscriptionName) {
        return (DeliveryAttributeListResultInner)this.getDeliveryAttributesWithResponse(scope, eventSubscriptionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionForTopicTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalBySubscriptionForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalBySubscriptionForTopicTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalBySubscriptionForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupForTopicTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listGlobalByResourceGroupForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listGlobalByResourceGroupForTopicTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listGlobalByResourceGroupForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionForTopicTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalBySubscriptionForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalBySubscriptionForTopicTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalBySubscriptionForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupForTopicTypeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRegionalByResourceGroupForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listRegionalByResourceGroupForTopicTypeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRegionalByResourceGroupForTopicTypeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByDomainTopicNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDomainTopicNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventSubscriptionInner>> listByDomainTopicNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDomainTopicNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventSubscriptionsListResult)res.getValue()).value(), ((EventSubscriptionsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementC")
    public static interface EventSubscriptionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") EventSubscriptionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") EventSubscriptionUpdateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getFullUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionFullUrlInner>> getFullUrl(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalBySubscriptionForTopicType(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="topicTypeName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalByResourceGroupForTopicType(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="topicTypeName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalBySubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="location") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalBySubscriptionForTopicType(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @PathParam(value="topicTypeName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalByResourceGroupForTopicType(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="location") String var4, @PathParam(value="topicTypeName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$top") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listByResource(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="providerNamespace") String var4, @PathParam(value="resourceTypeName") String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="$top") Integer var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}/topics/{topicName}/providers/Microsoft.EventGrid/eventSubscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listByDomainTopic(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="domainName") String var4, @PathParam(value="topicName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$top") Integer var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getDeliveryAttributes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributes(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="eventSubscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalBySubscriptionForTopicTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listGlobalByResourceGroupForTopicTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalBySubscriptionForTopicTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listRegionalByResourceGroupForTopicTypeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listByResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionsListResult>> listByDomainTopicNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

