/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.ClientsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import com.azure.resourcemanager.eventgrid.implementation.ClientImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.Client;
import com.azure.resourcemanager.eventgrid.models.Clients;

public final class ClientsImpl
implements Clients {
    private static final ClientLogger LOGGER = new ClientLogger(ClientsImpl.class);
    private final ClientsClient innerClient;
    private final EventGridManager serviceManager;

    public ClientsImpl(ClientsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Client> getWithResponse(String resourceGroupName, String namespaceName, String clientName, Context context) {
        Response<ClientInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, clientName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClientImpl((ClientInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Client get(String resourceGroupName, String namespaceName, String clientName) {
        ClientInner inner = this.serviceClient().get(resourceGroupName, namespaceName, clientName);
        if (inner != null) {
            return new ClientImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String clientName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String clientName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientName, context);
    }

    @Override
    public PagedIterable<Client> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<ClientInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientImpl((ClientInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Client> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        PagedIterable<ClientInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientImpl((ClientInner)((Object)inner1), this.manager()));
    }

    @Override
    public Client getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        return (Client)this.getWithResponse(resourceGroupName, namespaceName, clientName, Context.NONE).getValue();
    }

    @Override
    public Response<Client> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientName, context);
    }

    private ClientsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClientImpl define(String name) {
        return new ClientImpl(name, this.manager());
    }
}

