/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.Client;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.util.Collections;
import java.util.Map;

public final class ClientImpl
implements Client,
Client.Definition,
Client.Update {
    private ClientInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String clientName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String authenticationName() {
        return this.innerModel().authenticationName();
    }

    @Override
    public ClientCertificateAuthentication clientCertificateAuthentication() {
        return this.innerModel().clientCertificateAuthentication();
    }

    @Override
    public ClientState state() {
        return this.innerModel().state();
    }

    @Override
    public Map<String, Object> attributes() {
        Map<String, Object> inner = this.innerModel().attributes();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ClientProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClientInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClientImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public Client create() {
        this.innerObject = this.serviceManager.serviceClient().getClients().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Client create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClients().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientName, this.innerModel(), context);
        return this;
    }

    ClientImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new ClientInner();
        this.serviceManager = serviceManager;
        this.clientName = name;
    }

    @Override
    public ClientImpl update() {
        return this;
    }

    @Override
    public Client apply() {
        this.innerObject = this.serviceManager.serviceClient().getClients().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Client apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClients().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientName, this.innerModel(), context);
        return this;
    }

    ClientImpl(ClientInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.clientName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clients");
    }

    @Override
    public Client refresh() {
        this.innerObject = (ClientInner)((Object)this.serviceManager.serviceClient().getClients().getWithResponse(this.resourceGroupName, this.namespaceName, this.clientName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Client refresh(Context context) {
        this.innerObject = (ClientInner)((Object)this.serviceManager.serviceClient().getClients().getWithResponse(this.resourceGroupName, this.namespaceName, this.clientName, context).getValue());
        return this;
    }

    @Override
    public ClientImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public ClientImpl withAuthenticationName(String authenticationName) {
        this.innerModel().withAuthenticationName(authenticationName);
        return this;
    }

    @Override
    public ClientImpl withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication) {
        this.innerModel().withClientCertificateAuthentication(clientCertificateAuthentication);
        return this;
    }

    @Override
    public ClientImpl withState(ClientState state) {
        this.innerModel().withState(state);
        return this;
    }

    @Override
    public ClientImpl withAttributes(Map<String, Object> attributes) {
        this.innerModel().withAttributes(attributes);
        return this;
    }
}

