/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.ClientGroup;
import com.azure.resourcemanager.eventgrid.models.ClientGroupProvisioningState;

public final class ClientGroupImpl
implements ClientGroup,
ClientGroup.Definition,
ClientGroup.Update {
    private ClientGroupInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String namespaceName;
    private String clientGroupName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String query() {
        return this.innerModel().query();
    }

    @Override
    public ClientGroupProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClientGroupInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClientGroupImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        return this;
    }

    @Override
    public ClientGroup create() {
        this.innerObject = this.serviceManager.serviceClient().getClientGroups().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClientGroup create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClientGroups().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientGroupName, this.innerModel(), context);
        return this;
    }

    ClientGroupImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new ClientGroupInner();
        this.serviceManager = serviceManager;
        this.clientGroupName = name;
    }

    @Override
    public ClientGroupImpl update() {
        return this;
    }

    @Override
    public ClientGroup apply() {
        this.innerObject = this.serviceManager.serviceClient().getClientGroups().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClientGroup apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClientGroups().createOrUpdate(this.resourceGroupName, this.namespaceName, this.clientGroupName, this.innerModel(), context);
        return this;
    }

    ClientGroupImpl(ClientGroupInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.namespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "namespaces");
        this.clientGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clientGroups");
    }

    @Override
    public ClientGroup refresh() {
        this.innerObject = (ClientGroupInner)((Object)this.serviceManager.serviceClient().getClientGroups().getWithResponse(this.resourceGroupName, this.namespaceName, this.clientGroupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ClientGroup refresh(Context context) {
        this.innerObject = (ClientGroupInner)((Object)this.serviceManager.serviceClient().getClientGroups().getWithResponse(this.resourceGroupName, this.namespaceName, this.clientGroupName, context).getValue());
        return this;
    }

    @Override
    public ClientGroupImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public ClientGroupImpl withQuery(String query) {
        this.innerModel().withQuery(query);
        return this;
    }
}

