/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventgrid.fluent.ChannelsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientImpl;
import com.azure.resourcemanager.eventgrid.models.ChannelUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.ChannelsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ChannelsClientImpl
implements ChannelsClient {
    private final ChannelsService service;
    private final EventGridManagementClientImpl client;

    ChannelsClientImpl(EventGridManagementClientImpl client) {
        this.service = (ChannelsService)RestProxy.create(ChannelsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> getWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> getWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ChannelInner> getAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return this.getWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ChannelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChannelInner> getWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChannelInner get(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return (ChannelInner)((Object)this.getWithResponse(resourceGroupName, partnerNamespaceName, channelName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelInner channelInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelInfo is required and cannot be null."));
        }
        channelInfo.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), channelInfo, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelInner channelInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelInfo == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelInfo is required and cannot be null."));
        }
        channelInfo.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), channelInfo, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ChannelInner> createOrUpdateAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelInner channelInfo) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelInfo).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ChannelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChannelInner> createOrUpdateWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelInner channelInfo, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelInfo, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChannelInner createOrUpdate(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelInner channelInfo) {
        return (ChannelInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, partnerNamespaceName, channelName, channelInfo, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName) {
        this.deleteAsync(resourceGroupName, partnerNamespaceName, channelName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        this.deleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelUpdateParameters is required and cannot be null."));
        }
        channelUpdateParameters.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), channelUpdateParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelUpdateParameters is required and cannot be null."));
        }
        channelUpdateParameters.validate();
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), channelUpdateParameters, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> updateAsync(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters) {
        return this.updateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void update(String resourceGroupName, String partnerNamespaceName, String channelName, ChannelUpdateParameters channelUpdateParameters) {
        this.updateWithResponse(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceSinglePageAsync(String resourceGroupName, String partnerNamespaceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPartnerNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, this.client.getApiVersion(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChannelsListResult)res.getValue()).value(), ((ChannelsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceSinglePageAsync(String resourceGroupName, String partnerNamespaceName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByPartnerNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, this.client.getApiVersion(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChannelsListResult)res.getValue()).value(), ((ChannelsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName, String filter, Integer top) {
        return new PagedFlux(() -> this.listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top), nextLink -> this.listByPartnerNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top), nextLink -> this.listByPartnerNamespaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top, context), nextLink -> this.listByPartnerNamespaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChannelInner> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByPartnerNamespaceAsync(resourceGroupName, partnerNamespaceName, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChannelInner> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByPartnerNamespaceAsync(resourceGroupName, partnerNamespaceName, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventSubscriptionFullUrlInner> getFullUrlAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return this.getFullUrlWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName).flatMap(res -> Mono.justOrEmpty((Object)((EventSubscriptionFullUrlInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventSubscriptionFullUrlInner> getFullUrlWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        return (Response)this.getFullUrlWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventSubscriptionFullUrlInner getFullUrl(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return (EventSubscriptionFullUrlInner)this.getFullUrlWithResponse(resourceGroupName, partnerNamespaceName, channelName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPartnerNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChannelsListResult)res.getValue()).value(), ((ChannelsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByPartnerNamespaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChannelsListResult)res.getValue()).value(), ((ChannelsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventGridManagementC")
    public static interface ChannelsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ChannelInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @PathParam(value="channelName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ChannelInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @PathParam(value="channelName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ChannelInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @PathParam(value="channelName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @PathParam(value="channelName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ChannelUpdateParameters var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ChannelsListResult>> listByPartnerNamespace(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$top") Integer var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}/getFullUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventSubscriptionFullUrlInner>> getFullUrl(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="partnerNamespaceName") String var4, @PathParam(value="channelName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ChannelsListResult>> listByPartnerNamespaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

