/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.Channel;
import com.azure.resourcemanager.eventgrid.models.ChannelProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ChannelType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicInfo;
import com.azure.resourcemanager.eventgrid.models.ReadinessState;
import java.time.OffsetDateTime;

public final class ChannelImpl
implements Channel,
Channel.Definition,
Channel.Update {
    private ChannelInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String partnerNamespaceName;
    private String channelName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ChannelType channelType() {
        return this.innerModel().channelType();
    }

    @Override
    public PartnerTopicInfo partnerTopicInfo() {
        return this.innerModel().partnerTopicInfo();
    }

    @Override
    public String messageForActivation() {
        return this.innerModel().messageForActivation();
    }

    @Override
    public ChannelProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ReadinessState readinessState() {
        return this.innerModel().readinessState();
    }

    @Override
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerModel().expirationTimeIfNotActivatedUtc();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ChannelInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ChannelImpl withExistingPartnerNamespace(String resourceGroupName, String partnerNamespaceName) {
        this.resourceGroupName = resourceGroupName;
        this.partnerNamespaceName = partnerNamespaceName;
        return this;
    }

    @Override
    public Channel create() {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().createOrUpdateWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Channel create(Context context) {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().createOrUpdateWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, this.innerModel(), context).getValue());
        return this;
    }

    ChannelImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new ChannelInner();
        this.serviceManager = serviceManager;
        this.channelName = name;
    }

    @Override
    public ChannelImpl update() {
        return this;
    }

    @Override
    public Channel apply() {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().createOrUpdateWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Channel apply(Context context) {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().createOrUpdateWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, this.innerModel(), context).getValue());
        return this;
    }

    ChannelImpl(ChannelInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.partnerNamespaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "partnerNamespaces");
        this.channelName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "channels");
    }

    @Override
    public Channel refresh() {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().getWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Channel refresh(Context context) {
        this.innerObject = (ChannelInner)((Object)this.serviceManager.serviceClient().getChannels().getWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, context).getValue());
        return this;
    }

    @Override
    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(Context context) {
        return this.serviceManager.channels().getFullUrlWithResponse(this.resourceGroupName, this.partnerNamespaceName, this.channelName, context);
    }

    @Override
    public EventSubscriptionFullUrl getFullUrl() {
        return this.serviceManager.channels().getFullUrl(this.resourceGroupName, this.partnerNamespaceName, this.channelName);
    }

    @Override
    public ChannelImpl withChannelType(ChannelType channelType) {
        this.innerModel().withChannelType(channelType);
        return this;
    }

    @Override
    public ChannelImpl withPartnerTopicInfo(PartnerTopicInfo partnerTopicInfo) {
        this.innerModel().withPartnerTopicInfo(partnerTopicInfo);
        return this;
    }

    @Override
    public ChannelImpl withMessageForActivation(String messageForActivation) {
        this.innerModel().withMessageForActivation(messageForActivation);
        return this;
    }

    @Override
    public ChannelImpl withProvisioningState(ChannelProvisioningState provisioningState) {
        this.innerModel().withProvisioningState(provisioningState);
        return this;
    }

    @Override
    public ChannelImpl withReadinessState(ReadinessState readinessState) {
        this.innerModel().withReadinessState(readinessState);
        return this;
    }

    @Override
    public ChannelImpl withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.innerModel().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }
}

