/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SystemTopicProperties;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class SystemTopicInner
extends Resource {
    private SystemTopicProperties innerProperties;
    private SystemData systemData;
    private IdentityInfo identity;
    private String type;
    private String name;
    private String id;

    private SystemTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public SystemTopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SystemTopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SystemTopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ResourceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public SystemTopicInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public String topicType() {
        return this.innerProperties() == null ? null : this.innerProperties().topicType();
    }

    public SystemTopicInner withTopicType(String topicType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withTopicType(topicType);
        return this;
    }

    public String metricResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricResourceId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SystemTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (SystemTopicInner)((Object)jsonReader.readObject(reader -> {
            SystemTopicInner deserializedSystemTopicInner = new SystemTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSystemTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSystemTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSystemTopicInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSystemTopicInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSystemTopicInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSystemTopicInner.innerProperties = SystemTopicProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSystemTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSystemTopicInner.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSystemTopicInner;
        }));
    }
}

