/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationProvisioningState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class PartnerRegistrationProperties
implements JsonSerializable<PartnerRegistrationProperties> {
    private PartnerRegistrationProvisioningState provisioningState;
    private UUID partnerRegistrationImmutableId;

    public PartnerRegistrationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    public PartnerRegistrationProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId", Objects.toString(this.partnerRegistrationImmutableId, null));
        return jsonWriter.writeEndObject();
    }

    public static PartnerRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerRegistrationProperties)jsonReader.readObject(reader -> {
            PartnerRegistrationProperties deserializedPartnerRegistrationProperties = new PartnerRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerRegistrationProperties.provisioningState = PartnerRegistrationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartnerRegistrationProperties.partnerRegistrationImmutableId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerRegistrationProperties;
        });
    }
}

