/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class PartnerNamespaceUpdateParameterProperties
implements JsonSerializable<PartnerNamespaceUpdateParameterProperties> {
    private PublicNetworkAccess publicNetworkAccess;
    private List<InboundIpRule> inboundIpRules;
    private TlsVersion minimumTlsVersionAllowed;
    private Boolean disableLocalAuth;

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public PartnerNamespaceUpdateParameterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    public PartnerNamespaceUpdateParameterProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public PartnerNamespaceUpdateParameterProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public PartnerNamespaceUpdateParameterProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public void validate() {
        if (this.inboundIpRules() != null) {
            this.inboundIpRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        return jsonWriter.writeEndObject();
    }

    public static PartnerNamespaceUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerNamespaceUpdateParameterProperties)jsonReader.readObject(reader -> {
            PartnerNamespaceUpdateParameterProperties deserializedPartnerNamespaceUpdateParameterProperties = new PartnerNamespaceUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("inboundIpRules".equals(fieldName)) {
                    List inboundIpRules;
                    deserializedPartnerNamespaceUpdateParameterProperties.inboundIpRules = inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerNamespaceUpdateParameterProperties;
        });
    }
}

