/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupUpdateProperties;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.Identity;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import java.io.IOException;

public final class VolumeGroupUpdate
implements JsonSerializable<VolumeGroupUpdate> {
    private Identity identity;
    private VolumeGroupUpdateProperties innerProperties;

    public Identity identity() {
        return this.identity;
    }

    public VolumeGroupUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    private VolumeGroupUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public StorageTargetType protocolType() {
        return this.innerProperties() == null ? null : this.innerProperties().protocolType();
    }

    public VolumeGroupUpdate withProtocolType(StorageTargetType protocolType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withProtocolType(protocolType);
        return this;
    }

    public EncryptionType encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public VolumeGroupUpdate withEncryption(EncryptionType encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionProperties();
    }

    public VolumeGroupUpdate withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withEncryptionProperties(encryptionProperties);
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAcls();
    }

    public VolumeGroupUpdate withNetworkAcls(NetworkRuleSet networkAcls) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withNetworkAcls(networkAcls);
        return this;
    }

    public Boolean enforceDataIntegrityCheckForIscsi() {
        return this.innerProperties() == null ? null : this.innerProperties().enforceDataIntegrityCheckForIscsi();
    }

    public VolumeGroupUpdate withEnforceDataIntegrityCheckForIscsi(Boolean enforceDataIntegrityCheckForIscsi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withEnforceDataIntegrityCheckForIscsi(enforceDataIntegrityCheckForIscsi);
        return this;
    }

    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteRetentionPolicy();
    }

    public VolumeGroupUpdate withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupUpdateProperties();
        }
        this.innerProperties().withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupUpdate)jsonReader.readObject(reader -> {
            VolumeGroupUpdate deserializedVolumeGroupUpdate = new VolumeGroupUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedVolumeGroupUpdate.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeGroupUpdate.innerProperties = VolumeGroupUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupUpdate;
        });
    }
}

