/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupInner;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.Identity;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpointConnection;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import java.util.List;

public interface VolumeGroup {
    public String id();

    public String name();

    public String type();

    public Identity identity();

    public SystemData systemData();

    public ProvisioningStates provisioningState();

    public StorageTargetType protocolType();

    public EncryptionType encryption();

    public EncryptionProperties encryptionProperties();

    public NetworkRuleSet networkAcls();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public Boolean enforceDataIntegrityCheckForIscsi();

    public DeleteRetentionPolicy deleteRetentionPolicy();

    public String resourceGroupName();

    public VolumeGroupInner innerModel();

    public Update update();

    public VolumeGroup refresh();

    public VolumeGroup refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDeleteRetentionPolicy {
            public Update withDeleteRetentionPolicy(DeleteRetentionPolicy var1);
        }

        public static interface WithEnforceDataIntegrityCheckForIscsi {
            public Update withEnforceDataIntegrityCheckForIscsi(Boolean var1);
        }

        public static interface WithNetworkAcls {
            public Update withNetworkAcls(NetworkRuleSet var1);
        }

        public static interface WithEncryptionProperties {
            public Update withEncryptionProperties(EncryptionProperties var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(EncryptionType var1);
        }

        public static interface WithProtocolType {
            public Update withProtocolType(StorageTargetType var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithIdentity,
    UpdateStages.WithProtocolType,
    UpdateStages.WithEncryption,
    UpdateStages.WithEncryptionProperties,
    UpdateStages.WithNetworkAcls,
    UpdateStages.WithEnforceDataIntegrityCheckForIscsi,
    UpdateStages.WithDeleteRetentionPolicy {
        public VolumeGroup apply();

        public VolumeGroup apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDeleteRetentionPolicy {
            public WithCreate withDeleteRetentionPolicy(DeleteRetentionPolicy var1);
        }

        public static interface WithEnforceDataIntegrityCheckForIscsi {
            public WithCreate withEnforceDataIntegrityCheckForIscsi(Boolean var1);
        }

        public static interface WithNetworkAcls {
            public WithCreate withNetworkAcls(NetworkRuleSet var1);
        }

        public static interface WithEncryptionProperties {
            public WithCreate withEncryptionProperties(EncryptionProperties var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(EncryptionType var1);
        }

        public static interface WithProtocolType {
            public WithCreate withProtocolType(StorageTargetType var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithCreate
        extends WithIdentity,
        WithProtocolType,
        WithEncryption,
        WithEncryptionProperties,
        WithNetworkAcls,
        WithEnforceDataIntegrityCheckForIscsi,
        WithDeleteRetentionPolicy {
            public VolumeGroup create();

            public VolumeGroup create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingElasticSan(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

