/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.SkuName;
import com.azure.resourcemanager.elasticsan.models.SkuTier;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuName name;
    private SkuTier tier;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public Sku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return (Sku)jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSku.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

