/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.OperationalStatus;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import java.io.IOException;

public final class IscsiTargetInfo
implements JsonSerializable<IscsiTargetInfo> {
    private String targetIqn;
    private String targetPortalHostname;
    private Integer targetPortalPort;
    private ProvisioningStates provisioningState;
    private OperationalStatus status;

    public String targetIqn() {
        return this.targetIqn;
    }

    public String targetPortalHostname() {
        return this.targetPortalHostname;
    }

    public Integer targetPortalPort() {
        return this.targetPortalPort;
    }

    public ProvisioningStates provisioningState() {
        return this.provisioningState;
    }

    public OperationalStatus status() {
        return this.status;
    }

    public IscsiTargetInfo withStatus(OperationalStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static IscsiTargetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (IscsiTargetInfo)jsonReader.readObject(reader -> {
            IscsiTargetInfo deserializedIscsiTargetInfo = new IscsiTargetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetIqn".equals(fieldName)) {
                    deserializedIscsiTargetInfo.targetIqn = reader.getString();
                    continue;
                }
                if ("targetPortalHostname".equals(fieldName)) {
                    deserializedIscsiTargetInfo.targetPortalHostname = reader.getString();
                    continue;
                }
                if ("targetPortalPort".equals(fieldName)) {
                    deserializedIscsiTargetInfo.targetPortalPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedIscsiTargetInfo.provisioningState = ProvisioningStates.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedIscsiTargetInfo.status = OperationalStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIscsiTargetInfo;
        });
    }
}

