/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.EncryptionIdentity;
import com.azure.resourcemanager.elasticsan.models.KeyVaultProperties;
import java.io.IOException;

public final class EncryptionProperties
implements JsonSerializable<EncryptionProperties> {
    private KeyVaultProperties keyVaultProperties;
    private EncryptionIdentity encryptionIdentity;

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public EncryptionIdentity encryptionIdentity() {
        return this.encryptionIdentity;
    }

    public EncryptionProperties withEncryptionIdentity(EncryptionIdentity encryptionIdentity) {
        this.encryptionIdentity = encryptionIdentity;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.encryptionIdentity() != null) {
            this.encryptionIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.encryptionIdentity);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionProperties)jsonReader.readObject(reader -> {
            EncryptionProperties deserializedEncryptionProperties = new EncryptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedEncryptionProperties.encryptionIdentity = EncryptionIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProperties;
        });
    }
}

