/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.ElasticSanUpdateProperties;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import java.io.IOException;
import java.util.Map;

public final class ElasticSanUpdate
implements JsonSerializable<ElasticSanUpdate> {
    private ElasticSanUpdateProperties innerProperties;
    private Map<String, String> tags;

    private ElasticSanUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ElasticSanUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Long baseSizeTiB() {
        return this.innerProperties() == null ? null : this.innerProperties().baseSizeTiB();
    }

    public ElasticSanUpdate withBaseSizeTiB(Long baseSizeTiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanUpdateProperties();
        }
        this.innerProperties().withBaseSizeTiB(baseSizeTiB);
        return this;
    }

    public Long extendedCapacitySizeTiB() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedCapacitySizeTiB();
    }

    public ElasticSanUpdate withExtendedCapacitySizeTiB(Long extendedCapacitySizeTiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanUpdateProperties();
        }
        this.innerProperties().withExtendedCapacitySizeTiB(extendedCapacitySizeTiB);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ElasticSanUpdate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public AutoScaleProperties autoScaleProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleProperties();
    }

    public ElasticSanUpdate withAutoScaleProperties(AutoScaleProperties autoScaleProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanUpdateProperties();
        }
        this.innerProperties().withAutoScaleProperties(autoScaleProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticSanUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSanUpdate)jsonReader.readObject(reader -> {
            ElasticSanUpdate deserializedElasticSanUpdate = new ElasticSanUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedElasticSanUpdate.innerProperties = ElasticSanUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedElasticSanUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSanUpdate;
        });
    }
}

