/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.fluent.models.ElasticSanInner;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpointConnection;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import com.azure.resourcemanager.elasticsan.models.Sku;
import java.util.List;
import java.util.Map;

public interface ElasticSan {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public Sku sku();

    public List<String> availabilityZones();

    public ProvisioningStates provisioningState();

    public long baseSizeTiB();

    public long extendedCapacitySizeTiB();

    public Long totalVolumeSizeGiB();

    public Long volumeGroupCount();

    public Long totalIops();

    public Long totalMBps();

    public Long totalSizeTiB();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public PublicNetworkAccess publicNetworkAccess();

    public AutoScaleProperties autoScaleProperties();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ElasticSanInner innerModel();

    public Update update();

    public ElasticSan refresh();

    public ElasticSan refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithAutoScaleProperties {
            public Update withAutoScaleProperties(AutoScaleProperties var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithExtendedCapacitySizeTiB {
            public Update withExtendedCapacitySizeTiB(Long var1);
        }

        public static interface WithBaseSizeTiB {
            public Update withBaseSizeTiB(Long var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithBaseSizeTiB,
    UpdateStages.WithExtendedCapacitySizeTiB,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithAutoScaleProperties {
        public ElasticSan apply();

        public ElasticSan apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAutoScaleProperties {
            public WithCreate withAutoScaleProperties(AutoScaleProperties var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithAvailabilityZones {
            public WithCreate withAvailabilityZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAvailabilityZones,
        WithPublicNetworkAccess,
        WithAutoScaleProperties {
            public ElasticSan create();

            public ElasticSan create(Context var1);
        }

        public static interface WithExtendedCapacitySizeTiB {
            public WithCreate withExtendedCapacitySizeTiB(long var1);
        }

        public static interface WithBaseSizeTiB {
            public WithExtendedCapacitySizeTiB withBaseSizeTiB(long var1);
        }

        public static interface WithSku {
            public WithBaseSizeTiB withSku(Sku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithBaseSizeTiB,
    DefinitionStages.WithExtendedCapacitySizeTiB,
    DefinitionStages.WithCreate {
    }
}

