/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.VolumesClient;
import com.azure.resourcemanager.elasticsan.fluent.models.PreValidationResponseInner;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeInner;
import com.azure.resourcemanager.elasticsan.implementation.PreValidationResponseImpl;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.implementation.VolumeImpl;
import com.azure.resourcemanager.elasticsan.models.DeleteType;
import com.azure.resourcemanager.elasticsan.models.DiskSnapshotList;
import com.azure.resourcemanager.elasticsan.models.PreValidationResponse;
import com.azure.resourcemanager.elasticsan.models.Volume;
import com.azure.resourcemanager.elasticsan.models.VolumeNameList;
import com.azure.resourcemanager.elasticsan.models.Volumes;
import com.azure.resourcemanager.elasticsan.models.XMsAccessSoftDeletedResources;
import com.azure.resourcemanager.elasticsan.models.XMsDeleteSnapshots;
import com.azure.resourcemanager.elasticsan.models.XMsForceDelete;

public final class VolumesImpl
implements Volumes {
    private static final ClientLogger LOGGER = new ClientLogger(VolumesImpl.class);
    private final VolumesClient innerClient;
    private final ElasticSanManager serviceManager;

    public VolumesImpl(VolumesClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName, volumeName);
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context);
    }

    @Override
    public Response<Volume> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        Response<VolumeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeImpl((VolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Volume get(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        VolumeInner inner = this.serviceClient().get(resourceGroupName, elasticSanName, volumeGroupName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Volume> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        PagedIterable<VolumeInner> inner = this.serviceClient().listByVolumeGroup(resourceGroupName, elasticSanName, volumeGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Volume> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        PagedIterable<VolumeInner> inner = this.serviceClient().listByVolumeGroup(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PreValidationResponse preBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        PreValidationResponseInner inner = this.serviceClient().preBackup(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        if (inner != null) {
            return new PreValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PreValidationResponse preBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        PreValidationResponseInner inner = this.serviceClient().preBackup(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        if (inner != null) {
            return new PreValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PreValidationResponse preRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        PreValidationResponseInner inner = this.serviceClient().preRestore(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        if (inner != null) {
            return new PreValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PreValidationResponse preRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        PreValidationResponseInner inner = this.serviceClient().preRestore(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        if (inner != null) {
            return new PreValidationResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Volume getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return (Volume)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, volumeName, Context.NONE).getValue();
    }

    @Override
    public Response<Volume> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        XMsDeleteSnapshots localXMsDeleteSnapshots = null;
        XMsForceDelete localXMsForceDelete = null;
        DeleteType localDeleteType = null;
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, volumeName, localXMsDeleteSnapshots, localXMsForceDelete, localDeleteType, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context);
    }

    private VolumesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl define(String name) {
        return new VolumeImpl(name, this.manager());
    }
}

