/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.elasticsan.fluent.VolumesClient;
import com.azure.resourcemanager.elasticsan.fluent.models.PreValidationResponseInner;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeInner;
import com.azure.resourcemanager.elasticsan.implementation.ElasticSanManagementImpl;
import com.azure.resourcemanager.elasticsan.models.DeleteType;
import com.azure.resourcemanager.elasticsan.models.DiskSnapshotList;
import com.azure.resourcemanager.elasticsan.models.VolumeList;
import com.azure.resourcemanager.elasticsan.models.VolumeNameList;
import com.azure.resourcemanager.elasticsan.models.VolumeUpdate;
import com.azure.resourcemanager.elasticsan.models.XMsAccessSoftDeletedResources;
import com.azure.resourcemanager.elasticsan.models.XMsDeleteSnapshots;
import com.azure.resourcemanager.elasticsan.models.XMsForceDelete;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VolumesClientImpl
implements VolumesClient {
    private final VolumesService service;
    private final ElasticSanManagementImpl client;

    VolumesClientImpl(ElasticSanManagementImpl client) {
        this.service = (VolumesService)RestProxy.create(VolumesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters) {
        return (VolumeInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeInner parameters, Context context) {
        return (VolumeInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginUpdateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginUpdateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginUpdate(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginUpdate(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> updateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> updateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner update(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters) {
        return (VolumeInner)((Object)this.updateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner update(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, VolumeUpdate parameters, Context context) {
        return (VolumeInner)((Object)this.updateAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), xMsDeleteSnapshots, xMsForceDelete, deleteType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), xMsDeleteSnapshots, xMsForceDelete, deleteType, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        XMsDeleteSnapshots xMsDeleteSnapshots = null;
        XMsForceDelete xMsForceDelete = null;
        DeleteType deleteType = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        XMsDeleteSnapshots xMsDeleteSnapshots = null;
        XMsForceDelete xMsForceDelete = null;
        DeleteType deleteType = null;
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        XMsDeleteSnapshots xMsDeleteSnapshots = null;
        XMsForceDelete xMsForceDelete = null;
        DeleteType deleteType = null;
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        XMsDeleteSnapshots xMsDeleteSnapshots = null;
        XMsForceDelete xMsForceDelete = null;
        DeleteType deleteType = null;
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, XMsDeleteSnapshots xMsDeleteSnapshots, XMsForceDelete xMsForceDelete, DeleteType deleteType, Context context) {
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, xMsDeleteSnapshots, xMsForceDelete, deleteType, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> getAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        return this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VolumeInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VolumeInner> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner get(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        return (VolumeInner)((Object)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, volumeName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeInner>> listByVolumeGroupSinglePageAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVolumeGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), xMsAccessSoftDeletedResources, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeList)res.getValue()).value(), ((VolumeList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeInner>> listByVolumeGroupSinglePageAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVolumeGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), xMsAccessSoftDeletedResources, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeList)res.getValue()).value(), ((VolumeList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources = null;
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources, context), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeInner> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources = null;
        return new PagedIterable(this.listByVolumeGroupAsync(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeInner> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        return new PagedIterable(this.listByVolumeGroupAsync(resourceGroupName, elasticSanName, volumeGroupName, xMsAccessSoftDeletedResources, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> preBackupWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.preBackup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> preBackupWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.preBackup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreBackupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.preBackupWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PreValidationResponseInner.class), (Type)((Object)PreValidationResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreBackupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.preBackupWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PreValidationResponseInner.class), (Type)((Object)PreValidationResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        return this.beginPreBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        return this.beginPreBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PreValidationResponseInner> preBackupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        return this.beginPreBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PreValidationResponseInner> preBackupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        return this.beginPreBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PreValidationResponseInner preBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters) {
        return (PreValidationResponseInner)this.preBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PreValidationResponseInner preBackup(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeNameList parameters, Context context) {
        return (PreValidationResponseInner)this.preBackupAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> preRestoreWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.preRestore(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> preRestoreWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.preRestore(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreRestoreAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.preRestoreWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PreValidationResponseInner.class), (Type)((Object)PreValidationResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreRestoreAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.preRestoreWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PreValidationResponseInner.class), (Type)((Object)PreValidationResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        return this.beginPreRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PreValidationResponseInner>, PreValidationResponseInner> beginPreRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        return this.beginPreRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PreValidationResponseInner> preRestoreAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        return this.beginPreRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PreValidationResponseInner> preRestoreAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        return this.beginPreRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PreValidationResponseInner preRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters) {
        return (PreValidationResponseInner)this.preRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PreValidationResponseInner preRestore(String resourceGroupName, String elasticSanName, String volumeGroupName, DiskSnapshotList parameters, Context context) {
        return (PreValidationResponseInner)this.preRestoreAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeInner>> listByVolumeGroupNextSinglePageAsync(String nextLink, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVolumeGroupNext(nextLink, this.client.getEndpoint(), xMsAccessSoftDeletedResources, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeList)res.getValue()).value(), ((VolumeList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeInner>> listByVolumeGroupNextSinglePageAsync(String nextLink, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVolumeGroupNext(nextLink, this.client.getEndpoint(), xMsAccessSoftDeletedResources, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeList)res.getValue()).value(), ((VolumeList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ElasticSanManagement")
    public static interface VolumesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") VolumeInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") VolumeUpdate var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="x-ms-delete-snapshots") XMsDeleteSnapshots var8, @HeaderParam(value="x-ms-force-delete") XMsForceDelete var9, @QueryParam(value="deleteType") DeleteType var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeList>> listByVolumeGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="x-ms-access-soft-deleted-resources") XMsAccessSoftDeletedResources var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/preBackup")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> preBackup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") VolumeNameList var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/preRestore")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> preRestore(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DiskSnapshotList var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeList>> listByVolumeGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-access-soft-deleted-resources") XMsAccessSoftDeletedResources var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

