/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.VolumeSnapshotsClient;
import com.azure.resourcemanager.elasticsan.fluent.models.SnapshotInner;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.implementation.SnapshotImpl;
import com.azure.resourcemanager.elasticsan.models.Snapshot;
import com.azure.resourcemanager.elasticsan.models.VolumeSnapshots;

public final class VolumeSnapshotsImpl
implements VolumeSnapshots {
    private static final ClientLogger LOGGER = new ClientLogger(VolumeSnapshotsImpl.class);
    private final VolumeSnapshotsClient innerClient;
    private final ElasticSanManager serviceManager;

    public VolumeSnapshotsImpl(VolumeSnapshotsClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Snapshot> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        PagedIterable<SnapshotInner> inner = this.serviceClient().listByVolumeGroup(resourceGroupName, elasticSanName, volumeGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotImpl((SnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Snapshot> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter, Context context) {
        PagedIterable<SnapshotInner> inner = this.serviceClient().listByVolumeGroup(resourceGroupName, elasticSanName, volumeGroupName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotImpl((SnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName, snapshotName);
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context);
    }

    @Override
    public Response<Snapshot> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        Response<SnapshotInner> inner = this.serviceClient().getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SnapshotImpl((SnapshotInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Snapshot get(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        SnapshotInner inner = this.serviceClient().get(resourceGroupName, elasticSanName, volumeGroupName, snapshotName);
        if (inner != null) {
            return new SnapshotImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Snapshot getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return (Snapshot)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, Context.NONE).getValue();
    }

    @Override
    public Response<Snapshot> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context);
    }

    private VolumeSnapshotsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl define(String name) {
        return new SnapshotImpl(name, this.manager());
    }
}

