/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.elasticsan.fluent.VolumeSnapshotsClient;
import com.azure.resourcemanager.elasticsan.fluent.models.SnapshotInner;
import com.azure.resourcemanager.elasticsan.implementation.ElasticSanManagementImpl;
import com.azure.resourcemanager.elasticsan.models.SnapshotList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VolumeSnapshotsClientImpl
implements VolumeSnapshotsClient {
    private final VolumeSnapshotsService service;
    private final ElasticSanManagementImpl client;

    VolumeSnapshotsClientImpl(ElasticSanManagementImpl client) {
        this.service = (VolumeSnapshotsService)RestProxy.create(VolumeSnapshotsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SnapshotInner>> listByVolumeGroupSinglePageAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVolumeGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, filter, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotList)res.getValue()).value(), ((SnapshotList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SnapshotInner>> listByVolumeGroupSinglePageAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVolumeGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, filter, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotList)res.getValue()).value(), ((SnapshotList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SnapshotInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter) {
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, filter), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SnapshotInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        String filter = null;
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, filter), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SnapshotInner> listByVolumeGroupAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter, Context context) {
        return new PagedFlux(() -> this.listByVolumeGroupSinglePageAsync(resourceGroupName, elasticSanName, volumeGroupName, filter, context), nextLink -> this.listByVolumeGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SnapshotInner> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        String filter = null;
        return new PagedIterable(this.listByVolumeGroupAsync(resourceGroupName, elasticSanName, volumeGroupName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SnapshotInner> listByVolumeGroup(String resourceGroupName, String elasticSanName, String volumeGroupName, String filter, Context context) {
        return new PagedIterable(this.listByVolumeGroupAsync(resourceGroupName, elasticSanName, volumeGroupName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters) {
        return (SnapshotInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, SnapshotInner parameters, Context context) {
        return (SnapshotInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SnapshotInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SnapshotInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, snapshotName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> getAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        return this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SnapshotInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SnapshotInner> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner get(String resourceGroupName, String elasticSanName, String volumeGroupName, String snapshotName) {
        return (SnapshotInner)((Object)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, snapshotName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SnapshotInner>> listByVolumeGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVolumeGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotList)res.getValue()).value(), ((SnapshotList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SnapshotInner>> listByVolumeGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVolumeGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SnapshotList)res.getValue()).value(), ((SnapshotList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ElasticSanManagement")
    public static interface VolumeSnapshotsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotList>> listByVolumeGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="snapshotName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SnapshotInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="snapshotName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="snapshotName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotList>> listByVolumeGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

