/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeInner;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.models.IscsiTargetInfo;
import com.azure.resourcemanager.elasticsan.models.ManagedByInfo;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.SourceCreationData;
import com.azure.resourcemanager.elasticsan.models.Volume;
import com.azure.resourcemanager.elasticsan.models.VolumeUpdate;

public final class VolumeImpl
implements Volume,
Volume.Definition,
Volume.Update {
    private VolumeInner innerObject;
    private final ElasticSanManager serviceManager;
    private String resourceGroupName;
    private String elasticSanName;
    private String volumeGroupName;
    private String volumeName;
    private VolumeUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String volumeId() {
        return this.innerModel().volumeId();
    }

    @Override
    public SourceCreationData creationData() {
        return this.innerModel().creationData();
    }

    @Override
    public long sizeGiB() {
        return this.innerModel().sizeGiB();
    }

    @Override
    public IscsiTargetInfo storageTarget() {
        return this.innerModel().storageTarget();
    }

    @Override
    public ManagedByInfo managedBy() {
        return this.innerModel().managedBy();
    }

    @Override
    public ProvisioningStates provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VolumeInner innerModel() {
        return this.innerObject;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl withExistingVolumegroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        this.resourceGroupName = resourceGroupName;
        this.elasticSanName = elasticSanName;
        this.volumeGroupName = volumeGroupName;
        return this;
    }

    @Override
    public Volume create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Volume create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, this.innerModel(), context);
        return this;
    }

    VolumeImpl(String name, ElasticSanManager serviceManager) {
        this.innerObject = new VolumeInner();
        this.serviceManager = serviceManager;
        this.volumeName = name;
    }

    @Override
    public VolumeImpl update() {
        this.updateParameters = new VolumeUpdate();
        return this;
    }

    @Override
    public Volume apply() {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().update(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Volume apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().update(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, this.updateParameters, context);
        return this;
    }

    VolumeImpl(VolumeInner innerObject, ElasticSanManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.elasticSanName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticSans");
        this.volumeGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumegroups");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
    }

    @Override
    public Volume refresh() {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Volume refresh(Context context) {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.volumeName, context).getValue());
        return this;
    }

    @Override
    public VolumeImpl withSizeGiB(long sizeGiB) {
        this.innerModel().withSizeGiB(sizeGiB);
        return this;
    }

    @Override
    public VolumeImpl withCreationData(SourceCreationData creationData) {
        this.innerModel().withCreationData(creationData);
        return this;
    }

    @Override
    public VolumeImpl withManagedBy(ManagedByInfo managedBy) {
        if (this.isInCreateMode()) {
            this.innerModel().withManagedBy(managedBy);
            return this;
        }
        this.updateParameters.withManagedBy(managedBy);
        return this;
    }

    @Override
    public VolumeImpl withSizeGiB(Long sizeGiB) {
        this.updateParameters.withSizeGiB(sizeGiB);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

