/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.VolumeGroupsClient;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupInner;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.implementation.VolumeGroupImpl;
import com.azure.resourcemanager.elasticsan.models.VolumeGroup;
import com.azure.resourcemanager.elasticsan.models.VolumeGroups;
import com.azure.resourcemanager.elasticsan.models.XMsAccessSoftDeletedResources;

public final class VolumeGroupsImpl
implements VolumeGroups {
    private static final ClientLogger LOGGER = new ClientLogger(VolumeGroupsImpl.class);
    private final VolumeGroupsClient innerClient;
    private final ElasticSanManager serviceManager;

    public VolumeGroupsImpl(VolumeGroupsClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<VolumeGroup> listByElasticSan(String resourceGroupName, String elasticSanName) {
        PagedIterable<VolumeGroupInner> inner = this.serviceClient().listByElasticSan(resourceGroupName, elasticSanName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeGroupImpl((VolumeGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VolumeGroup> listByElasticSan(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        PagedIterable<VolumeGroupInner> inner = this.serviceClient().listByElasticSan(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeGroupImpl((VolumeGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName);
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, volumeGroupName, context);
    }

    @Override
    public Response<VolumeGroup> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        Response<VolumeGroupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeGroupImpl((VolumeGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VolumeGroup get(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        VolumeGroupInner inner = this.serviceClient().get(resourceGroupName, elasticSanName, volumeGroupName);
        if (inner != null) {
            return new VolumeGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VolumeGroup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        return (VolumeGroup)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<VolumeGroup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        String volumeGroupName = ResourceManagerUtils.getValueFromIdByName(id, "volumegroups");
        if (volumeGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumegroups'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, volumeGroupName, context);
    }

    private VolumeGroupsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeGroupImpl define(String name) {
        return new VolumeGroupImpl(name, this.manager());
    }
}

