/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.elasticsan.fluent.VolumeGroupsClient;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupInner;
import com.azure.resourcemanager.elasticsan.implementation.ElasticSanManagementImpl;
import com.azure.resourcemanager.elasticsan.models.VolumeGroupList;
import com.azure.resourcemanager.elasticsan.models.VolumeGroupUpdate;
import com.azure.resourcemanager.elasticsan.models.XMsAccessSoftDeletedResources;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VolumeGroupsClientImpl
implements VolumeGroupsClient {
    private final VolumeGroupsService service;
    private final ElasticSanManagementImpl client;

    VolumeGroupsClientImpl(ElasticSanManagementImpl client) {
        this.service = (VolumeGroupsService)RestProxy.create(VolumeGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeGroupInner>> listByElasticSanSinglePageAsync(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByElasticSan(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, this.client.getApiVersion(), xMsAccessSoftDeletedResources, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeGroupList)res.getValue()).value(), ((VolumeGroupList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeGroupInner>> listByElasticSanSinglePageAsync(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByElasticSan(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, this.client.getApiVersion(), xMsAccessSoftDeletedResources, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeGroupList)res.getValue()).value(), ((VolumeGroupList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeGroupInner> listByElasticSanAsync(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        return new PagedFlux(() -> this.listByElasticSanSinglePageAsync(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources), nextLink -> this.listByElasticSanNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeGroupInner> listByElasticSanAsync(String resourceGroupName, String elasticSanName) {
        XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources = null;
        return new PagedFlux(() -> this.listByElasticSanSinglePageAsync(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources), nextLink -> this.listByElasticSanNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VolumeGroupInner> listByElasticSanAsync(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        return new PagedFlux(() -> this.listByElasticSanSinglePageAsync(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources, context), nextLink -> this.listByElasticSanNextSinglePageAsync((String)nextLink, xMsAccessSoftDeletedResources, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeGroupInner> listByElasticSan(String resourceGroupName, String elasticSanName) {
        XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources = null;
        return new PagedIterable(this.listByElasticSanAsync(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VolumeGroupInner> listByElasticSan(String resourceGroupName, String elasticSanName, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        return new PagedIterable(this.listByElasticSanAsync(resourceGroupName, elasticSanName, xMsAccessSoftDeletedResources, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeGroupInner>, VolumeGroupInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeGroupInner.class), (Type)((Object)VolumeGroupInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeGroupInner>, VolumeGroupInner> beginCreateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeGroupInner.class), (Type)((Object)VolumeGroupInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeGroupInner>, VolumeGroupInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeGroupInner>, VolumeGroupInner> beginCreate(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeGroupInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeGroupInner> createAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeGroupInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters) {
        return (VolumeGroupInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeGroupInner create(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupInner parameters, Context context) {
        return (VolumeGroupInner)((Object)this.createAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeGroupInner>, VolumeGroupInner> beginUpdateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeGroupInner.class), (Type)((Object)VolumeGroupInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeGroupInner>, VolumeGroupInner> beginUpdateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeGroupInner.class), (Type)((Object)VolumeGroupInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeGroupInner>, VolumeGroupInner> beginUpdate(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeGroupInner>, VolumeGroupInner> beginUpdate(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeGroupInner> updateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeGroupInner> updateAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeGroupInner update(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters) {
        return (VolumeGroupInner)((Object)this.updateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeGroupInner update(String resourceGroupName, String elasticSanName, String volumeGroupName, VolumeGroupUpdate parameters, Context context) {
        return (VolumeGroupInner)((Object)this.updateAsync(resourceGroupName, elasticSanName, volumeGroupName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, elasticSanName, volumeGroupName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        this.deleteAsync(resourceGroupName, elasticSanName, volumeGroupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeGroupInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VolumeGroupInner>> getWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeGroupInner> getAsync(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        return this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VolumeGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VolumeGroupInner> getWithResponse(String resourceGroupName, String elasticSanName, String volumeGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeGroupInner get(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        return (VolumeGroupInner)((Object)this.getWithResponse(resourceGroupName, elasticSanName, volumeGroupName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeGroupInner>> listByElasticSanNextSinglePageAsync(String nextLink, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByElasticSanNext(nextLink, this.client.getEndpoint(), xMsAccessSoftDeletedResources, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeGroupList)res.getValue()).value(), ((VolumeGroupList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VolumeGroupInner>> listByElasticSanNextSinglePageAsync(String nextLink, XMsAccessSoftDeletedResources xMsAccessSoftDeletedResources, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByElasticSanNext(nextLink, this.client.getEndpoint(), xMsAccessSoftDeletedResources, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VolumeGroupList)res.getValue()).value(), ((VolumeGroupList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ElasticSanManagement")
    public static interface VolumeGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumeGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeGroupList>> listByElasticSan(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="x-ms-access-soft-deleted-resources") XMsAccessSoftDeletedResources var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") VolumeGroupInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") VolumeGroupUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VolumeGroupList>> listByElasticSanNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-access-soft-deleted-resources") XMsAccessSoftDeletedResources var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

