/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupInner;
import com.azure.resourcemanager.elasticsan.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.Identity;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpointConnection;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import com.azure.resourcemanager.elasticsan.models.VolumeGroup;
import com.azure.resourcemanager.elasticsan.models.VolumeGroupUpdate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class VolumeGroupImpl
implements VolumeGroup,
VolumeGroup.Definition,
VolumeGroup.Update {
    private VolumeGroupInner innerObject;
    private final ElasticSanManager serviceManager;
    private String resourceGroupName;
    private String elasticSanName;
    private String volumeGroupName;
    private VolumeGroupUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningStates provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public StorageTargetType protocolType() {
        return this.innerModel().protocolType();
    }

    @Override
    public EncryptionType encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public EncryptionProperties encryptionProperties() {
        return this.innerModel().encryptionProperties();
    }

    @Override
    public NetworkRuleSet networkAcls() {
        return this.innerModel().networkAcls();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean enforceDataIntegrityCheckForIscsi() {
        return this.innerModel().enforceDataIntegrityCheckForIscsi();
    }

    @Override
    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.innerModel().deleteRetentionPolicy();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VolumeGroupInner innerModel() {
        return this.innerObject;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeGroupImpl withExistingElasticSan(String resourceGroupName, String elasticSanName) {
        this.resourceGroupName = resourceGroupName;
        this.elasticSanName = elasticSanName;
        return this;
    }

    @Override
    public VolumeGroup create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VolumeGroup create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.innerModel(), context);
        return this;
    }

    VolumeGroupImpl(String name, ElasticSanManager serviceManager) {
        this.innerObject = new VolumeGroupInner();
        this.serviceManager = serviceManager;
        this.volumeGroupName = name;
    }

    @Override
    public VolumeGroupImpl update() {
        this.updateParameters = new VolumeGroupUpdate();
        return this;
    }

    @Override
    public VolumeGroup apply() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().update(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public VolumeGroup apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeGroups().update(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.updateParameters, context);
        return this;
    }

    VolumeGroupImpl(VolumeGroupInner innerObject, ElasticSanManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.elasticSanName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticSans");
        this.volumeGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumegroups");
    }

    @Override
    public VolumeGroup refresh() {
        this.innerObject = (VolumeGroupInner)((Object)this.serviceManager.serviceClient().getVolumeGroups().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VolumeGroup refresh(Context context) {
        this.innerObject = (VolumeGroupInner)((Object)this.serviceManager.serviceClient().getVolumeGroups().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, context).getValue());
        return this;
    }

    @Override
    public VolumeGroupImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public VolumeGroupImpl withProtocolType(StorageTargetType protocolType) {
        if (this.isInCreateMode()) {
            this.innerModel().withProtocolType(protocolType);
            return this;
        }
        this.updateParameters.withProtocolType(protocolType);
        return this;
    }

    @Override
    public VolumeGroupImpl withEncryption(EncryptionType encryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withEncryption(encryption);
            return this;
        }
        this.updateParameters.withEncryption(encryption);
        return this;
    }

    @Override
    public VolumeGroupImpl withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.isInCreateMode()) {
            this.innerModel().withEncryptionProperties(encryptionProperties);
            return this;
        }
        this.updateParameters.withEncryptionProperties(encryptionProperties);
        return this;
    }

    @Override
    public VolumeGroupImpl withNetworkAcls(NetworkRuleSet networkAcls) {
        if (this.isInCreateMode()) {
            this.innerModel().withNetworkAcls(networkAcls);
            return this;
        }
        this.updateParameters.withNetworkAcls(networkAcls);
        return this;
    }

    @Override
    public VolumeGroupImpl withEnforceDataIntegrityCheckForIscsi(Boolean enforceDataIntegrityCheckForIscsi) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnforceDataIntegrityCheckForIscsi(enforceDataIntegrityCheckForIscsi);
            return this;
        }
        this.updateParameters.withEnforceDataIntegrityCheckForIscsi(enforceDataIntegrityCheckForIscsi);
        return this;
    }

    @Override
    public VolumeGroupImpl withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withDeleteRetentionPolicy(deleteRetentionPolicy);
            return this;
        }
        this.updateParameters.withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

