/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.models.SnapshotInner;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.Snapshot;
import com.azure.resourcemanager.elasticsan.models.SnapshotCreationData;

public final class SnapshotImpl
implements Snapshot,
Snapshot.Definition {
    private SnapshotInner innerObject;
    private final ElasticSanManager serviceManager;
    private String resourceGroupName;
    private String elasticSanName;
    private String volumeGroupName;
    private String snapshotName;

    SnapshotImpl(SnapshotInner innerObject, ElasticSanManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SnapshotCreationData creationData() {
        return this.innerModel().creationData();
    }

    @Override
    public ProvisioningStates provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Long sourceVolumeSizeGiB() {
        return this.innerModel().sourceVolumeSizeGiB();
    }

    @Override
    public String volumeName() {
        return this.innerModel().volumeName();
    }

    @Override
    public SnapshotInner innerModel() {
        return this.innerObject;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl withExistingVolumegroup(String resourceGroupName, String elasticSanName, String volumeGroupName) {
        this.resourceGroupName = resourceGroupName;
        this.elasticSanName = elasticSanName;
        this.volumeGroupName = volumeGroupName;
        return this;
    }

    @Override
    public Snapshot create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeSnapshots().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.snapshotName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Snapshot create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeSnapshots().create(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.snapshotName, this.innerModel(), context);
        return this;
    }

    SnapshotImpl(String name, ElasticSanManager serviceManager) {
        this.innerObject = new SnapshotInner();
        this.serviceManager = serviceManager;
        this.snapshotName = name;
    }

    @Override
    public Snapshot refresh() {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getVolumeSnapshots().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.snapshotName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Snapshot refresh(Context context) {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getVolumeSnapshots().getWithResponse(this.resourceGroupName, this.elasticSanName, this.volumeGroupName, this.snapshotName, context).getValue());
        return this;
    }

    @Override
    public SnapshotImpl withCreationData(SnapshotCreationData creationData) {
        this.innerModel().withCreationData(creationData);
        return this;
    }
}

