/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.SkusClient;
import com.azure.resourcemanager.elasticsan.fluent.models.SkuInformationInner;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.implementation.SkuInformationImpl;
import com.azure.resourcemanager.elasticsan.models.SkuInformation;
import com.azure.resourcemanager.elasticsan.models.Skus;

public final class SkusImpl
implements Skus {
    private static final ClientLogger LOGGER = new ClientLogger(SkusImpl.class);
    private final SkusClient innerClient;
    private final ElasticSanManager serviceManager;

    public SkusImpl(SkusClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SkuInformation> list() {
        PagedIterable<SkuInformationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuInformationImpl((SkuInformationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SkuInformation> list(String filter, Context context) {
        PagedIterable<SkuInformationInner> inner = this.serviceClient().list(filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuInformationImpl((SkuInformationInner)inner1, this.manager()));
    }

    private SkusClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }
}

