/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeInner;
import com.azure.resourcemanager.elasticsan.implementation.VolumeImpl;
import com.azure.resourcemanager.elasticsan.models.ResourceProviders;
import com.azure.resourcemanager.elasticsan.models.Volume;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final ElasticSanManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Volume restoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        VolumeInner inner = this.serviceClient().restoreVolume(resourceGroupName, elasticSanName, volumeGroupName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Volume restoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        VolumeInner inner = this.serviceClient().restoreVolume(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }
}

