/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.elasticsan.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeInner;
import com.azure.resourcemanager.elasticsan.implementation.ElasticSanManagementImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final ElasticSanManagementImpl client;

    ResourceProvidersClientImpl(ElasticSanManagementImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreVolumeWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreVolume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreVolumeWithResponseAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (elasticSanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticSanName is required and cannot be null."));
        }
        if (volumeGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeGroupName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restoreVolume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, elasticSanName, volumeGroupName, volumeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginRestoreVolumeAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreVolumeWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VolumeInner>, VolumeInner> beginRestoreVolumeAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreVolumeWithResponseAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)VolumeInner.class), (Type)((Object)VolumeInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginRestoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        return this.beginRestoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VolumeInner>, VolumeInner> beginRestoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        return this.beginRestoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> restoreVolumeAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        return this.beginRestoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VolumeInner> restoreVolumeAsync(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        return this.beginRestoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner restoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName) {
        return (VolumeInner)((Object)this.restoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VolumeInner restoreVolume(String resourceGroupName, String elasticSanName, String volumeGroupName, String volumeName, Context context) {
        return (VolumeInner)((Object)this.restoreVolumeAsync(resourceGroupName, elasticSanName, volumeGroupName, volumeName, context).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ElasticSanManagement")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}/restore")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restoreVolume(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="elasticSanName") String var4, @PathParam(value="volumeGroupName") String var5, @PathParam(value="volumeName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

