/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateLinkResourceListResultInner;
import com.azure.resourcemanager.elasticsan.implementation.PrivateLinkResourceListResultImpl;
import com.azure.resourcemanager.elasticsan.models.PrivateLinkResourceListResult;
import com.azure.resourcemanager.elasticsan.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final ElasticSanManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateLinkResourceListResult> listByElasticSanWithResponse(String resourceGroupName, String elasticSanName, Context context) {
        Response<PrivateLinkResourceListResultInner> inner = this.serviceClient().listByElasticSanWithResponse(resourceGroupName, elasticSanName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceListResultImpl((PrivateLinkResourceListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResourceListResult listByElasticSan(String resourceGroupName, String elasticSanName) {
        PrivateLinkResourceListResultInner inner = this.serviceClient().listByElasticSan(resourceGroupName, elasticSanName);
        if (inner != null) {
            return new PrivateLinkResourceListResultImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }
}

