/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpoint;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpointConnection;
import com.azure.resourcemanager.elasticsan.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import java.util.Collections;
import java.util.List;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition {
    private PrivateEndpointConnectionInner innerObject;
    private final ElasticSanManager serviceManager;
    private String resourceGroupName;
    private String elasticSanName;
    private String privateEndpointConnectionName;

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, ElasticSanManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningStates provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    @Override
    public List<String> groupIds() {
        List<String> inner = this.innerModel().groupIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingElasticSan(String resourceGroupName, String elasticSanName) {
        this.resourceGroupName = resourceGroupName;
        this.elasticSanName = elasticSanName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().create(this.resourceGroupName, this.elasticSanName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().create(this.resourceGroupName, this.elasticSanName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name, ElasticSanManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.elasticSanName, this.privateEndpointConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.elasticSanName, this.privateEndpointConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.innerModel().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.innerModel().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withGroupIds(List<String> groupIds) {
        this.innerModel().withGroupIds(groupIds);
        return this;
    }
}

