/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.ElasticSansClient;
import com.azure.resourcemanager.elasticsan.fluent.models.ElasticSanInner;
import com.azure.resourcemanager.elasticsan.implementation.ElasticSanImpl;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.models.ElasticSan;
import com.azure.resourcemanager.elasticsan.models.ElasticSans;

public final class ElasticSansImpl
implements ElasticSans {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticSansImpl.class);
    private final ElasticSansClient innerClient;
    private final ElasticSanManager serviceManager;

    public ElasticSansImpl(ElasticSansClient innerClient, ElasticSanManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ElasticSan> list() {
        PagedIterable<ElasticSanInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSanImpl((ElasticSanInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticSan> list(Context context) {
        PagedIterable<ElasticSanInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSanImpl((ElasticSanInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticSan> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ElasticSanInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSanImpl((ElasticSanInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticSan> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ElasticSanInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSanImpl((ElasticSanInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String elasticSanName) {
        this.serviceClient().delete(resourceGroupName, elasticSanName);
    }

    @Override
    public void delete(String resourceGroupName, String elasticSanName, Context context) {
        this.serviceClient().delete(resourceGroupName, elasticSanName, context);
    }

    @Override
    public Response<ElasticSan> getByResourceGroupWithResponse(String resourceGroupName, String elasticSanName, Context context) {
        Response<ElasticSanInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, elasticSanName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticSanImpl((ElasticSanInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticSan getByResourceGroup(String resourceGroupName, String elasticSanName) {
        ElasticSanInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, elasticSanName);
        if (inner != null) {
            return new ElasticSanImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticSan getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        return (ElasticSan)this.getByResourceGroupWithResponse(resourceGroupName, elasticSanName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticSan> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, elasticSanName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String elasticSanName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSans");
        if (elasticSanName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSans'.", id)));
        }
        this.delete(resourceGroupName, elasticSanName, context);
    }

    private ElasticSansClient serviceClient() {
        return this.innerClient;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSanImpl define(String name) {
        return new ElasticSanImpl(name, this.manager());
    }
}

