/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elasticsan.ElasticSanManager;
import com.azure.resourcemanager.elasticsan.fluent.models.ElasticSanInner;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.elasticsan.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.ElasticSan;
import com.azure.resourcemanager.elasticsan.models.ElasticSanUpdate;
import com.azure.resourcemanager.elasticsan.models.PrivateEndpointConnection;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import com.azure.resourcemanager.elasticsan.models.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ElasticSanImpl
implements ElasticSan,
ElasticSan.Definition,
ElasticSan.Update {
    private ElasticSanInner innerObject;
    private final ElasticSanManager serviceManager;
    private String resourceGroupName;
    private String elasticSanName;
    private ElasticSanUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public List<String> availabilityZones() {
        List<String> inner = this.innerModel().availabilityZones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProvisioningStates provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public long baseSizeTiB() {
        return this.innerModel().baseSizeTiB();
    }

    @Override
    public long extendedCapacitySizeTiB() {
        return this.innerModel().extendedCapacitySizeTiB();
    }

    @Override
    public Long totalVolumeSizeGiB() {
        return this.innerModel().totalVolumeSizeGiB();
    }

    @Override
    public Long volumeGroupCount() {
        return this.innerModel().volumeGroupCount();
    }

    @Override
    public Long totalIops() {
        return this.innerModel().totalIops();
    }

    @Override
    public Long totalMBps() {
        return this.innerModel().totalMBps();
    }

    @Override
    public Long totalSizeTiB() {
        return this.innerModel().totalSizeTiB();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public AutoScaleProperties autoScaleProperties() {
        return this.innerModel().autoScaleProperties();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticSanInner innerModel() {
        return this.innerObject;
    }

    private ElasticSanManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSanImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ElasticSan create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSans().create(this.resourceGroupName, this.elasticSanName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticSan create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSans().create(this.resourceGroupName, this.elasticSanName, this.innerModel(), context);
        return this;
    }

    ElasticSanImpl(String name, ElasticSanManager serviceManager) {
        this.innerObject = new ElasticSanInner();
        this.serviceManager = serviceManager;
        this.elasticSanName = name;
    }

    @Override
    public ElasticSanImpl update() {
        this.updateParameters = new ElasticSanUpdate();
        return this;
    }

    @Override
    public ElasticSan apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSans().update(this.resourceGroupName, this.elasticSanName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public ElasticSan apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSans().update(this.resourceGroupName, this.elasticSanName, this.updateParameters, context);
        return this;
    }

    ElasticSanImpl(ElasticSanInner innerObject, ElasticSanManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.elasticSanName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticSans");
    }

    @Override
    public ElasticSan refresh() {
        this.innerObject = (ElasticSanInner)((Object)this.serviceManager.serviceClient().getElasticSans().getByResourceGroupWithResponse(this.resourceGroupName, this.elasticSanName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticSan refresh(Context context) {
        this.innerObject = (ElasticSanInner)((Object)this.serviceManager.serviceClient().getElasticSans().getByResourceGroupWithResponse(this.resourceGroupName, this.elasticSanName, context).getValue());
        return this;
    }

    @Override
    public ElasticSanImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticSanImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticSanImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public ElasticSanImpl withBaseSizeTiB(long baseSizeTiB) {
        this.innerModel().withBaseSizeTiB(baseSizeTiB);
        return this;
    }

    @Override
    public ElasticSanImpl withExtendedCapacitySizeTiB(long extendedCapacitySizeTiB) {
        this.innerModel().withExtendedCapacitySizeTiB(extendedCapacitySizeTiB);
        return this;
    }

    @Override
    public ElasticSanImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ElasticSanImpl withAvailabilityZones(List<String> availabilityZones) {
        this.innerModel().withAvailabilityZones(availabilityZones);
        return this;
    }

    @Override
    public ElasticSanImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ElasticSanImpl withAutoScaleProperties(AutoScaleProperties autoScaleProperties) {
        if (this.isInCreateMode()) {
            this.innerModel().withAutoScaleProperties(autoScaleProperties);
            return this;
        }
        this.updateParameters.withAutoScaleProperties(autoScaleProperties);
        return this;
    }

    @Override
    public ElasticSanImpl withBaseSizeTiB(Long baseSizeTiB) {
        this.updateParameters.withBaseSizeTiB(baseSizeTiB);
        return this;
    }

    @Override
    public ElasticSanImpl withExtendedCapacitySizeTiB(Long extendedCapacitySizeTiB) {
        this.updateParameters.withExtendedCapacitySizeTiB(extendedCapacitySizeTiB);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

