/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.IscsiTargetInfo;
import com.azure.resourcemanager.elasticsan.models.ManagedByInfo;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.SourceCreationData;
import java.io.IOException;

public final class VolumeProperties
implements JsonSerializable<VolumeProperties> {
    private String volumeId;
    private SourceCreationData creationData;
    private long sizeGiB;
    private IscsiTargetInfo storageTarget;
    private ManagedByInfo managedBy;
    private ProvisioningStates provisioningState;

    public String volumeId() {
        return this.volumeId;
    }

    public SourceCreationData creationData() {
        return this.creationData;
    }

    public VolumeProperties withCreationData(SourceCreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public long sizeGiB() {
        return this.sizeGiB;
    }

    public VolumeProperties withSizeGiB(long sizeGiB) {
        this.sizeGiB = sizeGiB;
        return this;
    }

    public IscsiTargetInfo storageTarget() {
        return this.storageTarget;
    }

    public ManagedByInfo managedBy() {
        return this.managedBy;
    }

    public VolumeProperties withManagedBy(ManagedByInfo managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.storageTarget() != null) {
            this.storageTarget().validate();
        }
        if (this.managedBy() != null) {
            this.managedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("sizeGiB", this.sizeGiB);
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData);
        jsonWriter.writeJsonField("managedBy", (JsonSerializable)this.managedBy);
        return jsonWriter.writeEndObject();
    }

    public static VolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeProperties)jsonReader.readObject(reader -> {
            VolumeProperties deserializedVolumeProperties = new VolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeGiB".equals(fieldName)) {
                    deserializedVolumeProperties.sizeGiB = reader.getLong();
                    continue;
                }
                if ("volumeId".equals(fieldName)) {
                    deserializedVolumeProperties.volumeId = reader.getString();
                    continue;
                }
                if ("creationData".equals(fieldName)) {
                    deserializedVolumeProperties.creationData = SourceCreationData.fromJson(reader);
                    continue;
                }
                if ("storageTarget".equals(fieldName)) {
                    deserializedVolumeProperties.storageTarget = IscsiTargetInfo.fromJson(reader);
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedVolumeProperties.managedBy = ManagedByInfo.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeProperties.provisioningState = ProvisioningStates.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeProperties;
        });
    }
}

