/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeProperties;
import com.azure.resourcemanager.elasticsan.models.IscsiTargetInfo;
import com.azure.resourcemanager.elasticsan.models.ManagedByInfo;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.SourceCreationData;
import java.io.IOException;

public final class VolumeInner
extends ProxyResource {
    private VolumeProperties innerProperties = new VolumeProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(VolumeInner.class);

    private VolumeProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String volumeId() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeId();
    }

    public SourceCreationData creationData() {
        return this.innerProperties() == null ? null : this.innerProperties().creationData();
    }

    public VolumeInner withCreationData(SourceCreationData creationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCreationData(creationData);
        return this;
    }

    public long sizeGiB() {
        return this.innerProperties() == null ? 0L : this.innerProperties().sizeGiB();
    }

    public VolumeInner withSizeGiB(long sizeGiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSizeGiB(sizeGiB);
        return this;
    }

    public IscsiTargetInfo storageTarget() {
        return this.innerProperties() == null ? null : this.innerProperties().storageTarget();
    }

    public ManagedByInfo managedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().managedBy();
    }

    public VolumeInner withManagedBy(ManagedByInfo managedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withManagedBy(managedBy);
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VolumeInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeInner fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeInner)((Object)jsonReader.readObject(reader -> {
            VolumeInner deserializedVolumeInner = new VolumeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVolumeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeInner.innerProperties = VolumeProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVolumeInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeInner;
        }));
    }
}

