/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import java.io.IOException;

public final class VolumeGroupUpdateProperties
implements JsonSerializable<VolumeGroupUpdateProperties> {
    private StorageTargetType protocolType;
    private EncryptionType encryption;
    private EncryptionProperties encryptionProperties;
    private NetworkRuleSet networkAcls;
    private Boolean enforceDataIntegrityCheckForIscsi;
    private DeleteRetentionPolicy deleteRetentionPolicy;

    public StorageTargetType protocolType() {
        return this.protocolType;
    }

    public VolumeGroupUpdateProperties withProtocolType(StorageTargetType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public EncryptionType encryption() {
        return this.encryption;
    }

    public VolumeGroupUpdateProperties withEncryption(EncryptionType encryption) {
        this.encryption = encryption;
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    public VolumeGroupUpdateProperties withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VolumeGroupUpdateProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public Boolean enforceDataIntegrityCheckForIscsi() {
        return this.enforceDataIntegrityCheckForIscsi;
    }

    public VolumeGroupUpdateProperties withEnforceDataIntegrityCheckForIscsi(Boolean enforceDataIntegrityCheckForIscsi) {
        this.enforceDataIntegrityCheckForIscsi = enforceDataIntegrityCheckForIscsi;
        return this;
    }

    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.deleteRetentionPolicy;
    }

    public VolumeGroupUpdateProperties withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        this.deleteRetentionPolicy = deleteRetentionPolicy;
        return this;
    }

    public void validate() {
        if (this.encryptionProperties() != null) {
            this.encryptionProperties().validate();
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.deleteRetentionPolicy() != null) {
            this.deleteRetentionPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType == null ? null : this.protocolType.toString());
        jsonWriter.writeStringField("encryption", this.encryption == null ? null : this.encryption.toString());
        jsonWriter.writeJsonField("encryptionProperties", (JsonSerializable)this.encryptionProperties);
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        jsonWriter.writeBooleanField("enforceDataIntegrityCheckForIscsi", this.enforceDataIntegrityCheckForIscsi);
        jsonWriter.writeJsonField("deleteRetentionPolicy", (JsonSerializable)this.deleteRetentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupUpdateProperties)jsonReader.readObject(reader -> {
            VolumeGroupUpdateProperties deserializedVolumeGroupUpdateProperties = new VolumeGroupUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocolType".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.protocolType = StorageTargetType.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.encryption = EncryptionType.fromString(reader.getString());
                    continue;
                }
                if ("encryptionProperties".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.encryptionProperties = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.networkAcls = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("enforceDataIntegrityCheckForIscsi".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.enforceDataIntegrityCheckForIscsi = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deleteRetentionPolicy".equals(fieldName)) {
                    deserializedVolumeGroupUpdateProperties.deleteRetentionPolicy = DeleteRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupUpdateProperties;
        });
    }
}

