/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import java.io.IOException;
import java.util.List;

public final class VolumeGroupProperties
implements JsonSerializable<VolumeGroupProperties> {
    private ProvisioningStates provisioningState;
    private StorageTargetType protocolType;
    private EncryptionType encryption;
    private EncryptionProperties encryptionProperties;
    private NetworkRuleSet networkAcls;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean enforceDataIntegrityCheckForIscsi;
    private DeleteRetentionPolicy deleteRetentionPolicy;

    public ProvisioningStates provisioningState() {
        return this.provisioningState;
    }

    public StorageTargetType protocolType() {
        return this.protocolType;
    }

    public VolumeGroupProperties withProtocolType(StorageTargetType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public EncryptionType encryption() {
        return this.encryption;
    }

    public VolumeGroupProperties withEncryption(EncryptionType encryption) {
        this.encryption = encryption;
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    public VolumeGroupProperties withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VolumeGroupProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public Boolean enforceDataIntegrityCheckForIscsi() {
        return this.enforceDataIntegrityCheckForIscsi;
    }

    public VolumeGroupProperties withEnforceDataIntegrityCheckForIscsi(Boolean enforceDataIntegrityCheckForIscsi) {
        this.enforceDataIntegrityCheckForIscsi = enforceDataIntegrityCheckForIscsi;
        return this;
    }

    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.deleteRetentionPolicy;
    }

    public VolumeGroupProperties withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        this.deleteRetentionPolicy = deleteRetentionPolicy;
        return this;
    }

    public void validate() {
        if (this.encryptionProperties() != null) {
            this.encryptionProperties().validate();
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.deleteRetentionPolicy() != null) {
            this.deleteRetentionPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType == null ? null : this.protocolType.toString());
        jsonWriter.writeStringField("encryption", this.encryption == null ? null : this.encryption.toString());
        jsonWriter.writeJsonField("encryptionProperties", (JsonSerializable)this.encryptionProperties);
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        jsonWriter.writeBooleanField("enforceDataIntegrityCheckForIscsi", this.enforceDataIntegrityCheckForIscsi);
        jsonWriter.writeJsonField("deleteRetentionPolicy", (JsonSerializable)this.deleteRetentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupProperties)jsonReader.readObject(reader -> {
            VolumeGroupProperties deserializedVolumeGroupProperties = new VolumeGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeGroupProperties.provisioningState = ProvisioningStates.fromString(reader.getString());
                    continue;
                }
                if ("protocolType".equals(fieldName)) {
                    deserializedVolumeGroupProperties.protocolType = StorageTargetType.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedVolumeGroupProperties.encryption = EncryptionType.fromString(reader.getString());
                    continue;
                }
                if ("encryptionProperties".equals(fieldName)) {
                    deserializedVolumeGroupProperties.encryptionProperties = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedVolumeGroupProperties.networkAcls = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedVolumeGroupProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("enforceDataIntegrityCheckForIscsi".equals(fieldName)) {
                    deserializedVolumeGroupProperties.enforceDataIntegrityCheckForIscsi = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deleteRetentionPolicy".equals(fieldName)) {
                    deserializedVolumeGroupProperties.deleteRetentionPolicy = DeleteRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupProperties;
        });
    }
}

