/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.fluent.models.VolumeGroupProperties;
import com.azure.resourcemanager.elasticsan.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.elasticsan.models.EncryptionProperties;
import com.azure.resourcemanager.elasticsan.models.EncryptionType;
import com.azure.resourcemanager.elasticsan.models.Identity;
import com.azure.resourcemanager.elasticsan.models.NetworkRuleSet;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.StorageTargetType;
import java.io.IOException;
import java.util.List;

public final class VolumeGroupInner
extends ProxyResource {
    private Identity identity;
    private VolumeGroupProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public Identity identity() {
        return this.identity;
    }

    public VolumeGroupInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    private VolumeGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProvisioningStates provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public StorageTargetType protocolType() {
        return this.innerProperties() == null ? null : this.innerProperties().protocolType();
    }

    public VolumeGroupInner withProtocolType(StorageTargetType protocolType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withProtocolType(protocolType);
        return this;
    }

    public EncryptionType encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public VolumeGroupInner withEncryption(EncryptionType encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionProperties();
    }

    public VolumeGroupInner withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withEncryptionProperties(encryptionProperties);
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAcls();
    }

    public VolumeGroupInner withNetworkAcls(NetworkRuleSet networkAcls) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withNetworkAcls(networkAcls);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public Boolean enforceDataIntegrityCheckForIscsi() {
        return this.innerProperties() == null ? null : this.innerProperties().enforceDataIntegrityCheckForIscsi();
    }

    public VolumeGroupInner withEnforceDataIntegrityCheckForIscsi(Boolean enforceDataIntegrityCheckForIscsi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withEnforceDataIntegrityCheckForIscsi(enforceDataIntegrityCheckForIscsi);
        return this;
    }

    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteRetentionPolicy();
    }

    public VolumeGroupInner withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeGroupProperties();
        }
        this.innerProperties().withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupInner)((Object)jsonReader.readObject(reader -> {
            VolumeGroupInner deserializedVolumeGroupInner = new VolumeGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVolumeGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeGroupInner.type = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVolumeGroupInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVolumeGroupInner.innerProperties = VolumeGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVolumeGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupInner;
        }));
    }
}

