/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.SnapshotCreationData;
import java.io.IOException;

public final class SnapshotProperties
implements JsonSerializable<SnapshotProperties> {
    private SnapshotCreationData creationData;
    private ProvisioningStates provisioningState;
    private Long sourceVolumeSizeGiB;
    private String volumeName;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotProperties.class);

    public SnapshotCreationData creationData() {
        return this.creationData;
    }

    public SnapshotProperties withCreationData(SnapshotCreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.provisioningState;
    }

    public Long sourceVolumeSizeGiB() {
        return this.sourceVolumeSizeGiB;
    }

    public String volumeName() {
        return this.volumeName;
    }

    public void validate() {
        if (this.creationData() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property creationData in model SnapshotProperties"));
        }
        this.creationData().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotProperties)jsonReader.readObject(reader -> {
            SnapshotProperties deserializedSnapshotProperties = new SnapshotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationData".equals(fieldName)) {
                    deserializedSnapshotProperties.creationData = SnapshotCreationData.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSnapshotProperties.provisioningState = ProvisioningStates.fromString(reader.getString());
                    continue;
                }
                if ("sourceVolumeSizeGiB".equals(fieldName)) {
                    deserializedSnapshotProperties.sourceVolumeSizeGiB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("volumeName".equals(fieldName)) {
                    deserializedSnapshotProperties.volumeName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotProperties;
        });
    }
}

