/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.SnapshotProperties;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.SnapshotCreationData;
import java.io.IOException;

public final class SnapshotInner
extends ProxyResource {
    private SnapshotProperties innerProperties = new SnapshotProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotInner.class);

    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SnapshotCreationData creationData() {
        return this.innerProperties() == null ? null : this.innerProperties().creationData();
    }

    public SnapshotInner withCreationData(SnapshotCreationData creationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withCreationData(creationData);
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Long sourceVolumeSizeGiB() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceVolumeSizeGiB();
    }

    public String volumeName() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeName();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SnapshotInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotInner fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotInner)((Object)jsonReader.readObject(reader -> {
            SnapshotInner deserializedSnapshotInner = new SnapshotInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSnapshotInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotInner.innerProperties = SnapshotProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSnapshotInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotInner;
        }));
    }
}

